/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.exporter;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporter;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;

public final class LocalIndexExporter
implements QueryInsightsExporter {
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private DateTimeFormatter indexPattern;

    public LocalIndexExporter(Client client, DateTimeFormatter indexPattern) {
        this.indexPattern = indexPattern;
        this.client = client;
    }

    public DateTimeFormatter getIndexPattern() {
        return this.indexPattern;
    }

    public LocalIndexExporter setIndexPattern(DateTimeFormatter indexPattern) {
        this.indexPattern = indexPattern;
        return this;
    }

    @Override
    public void export(List<SearchQueryRecord> records) {
        if (records == null || records.size() == 0) {
            return;
        }
        try {
            String index = this.getDateTimeFromFormat();
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk().setTimeout(TimeValue.timeValueMinutes((long)1L));
            for (SearchQueryRecord record : records) {
                bulkRequestBuilder.add(new IndexRequest(index).source(record.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            }
            bulkRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse bulkItemResponses) {
                }

                public void onFailure(Exception e) {
                    LocalIndexExporter.this.logger.error("Failed to execute bulk operation for query insights data: ", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Unable to index query insights data: ", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.logger.debug("Closing the LocalIndexExporter..");
    }

    private String getDateTimeFromFormat() {
        return this.indexPattern.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }
}

