/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.plugin.insights.core.service.categorizer.QueryShapeVisitor;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryAggregationCategorizer;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCategorizingVisitor;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCounters;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public final class SearchQueryCategorizer {
    private static final Logger log = LogManager.getLogger(SearchQueryCategorizer.class);
    private final SearchQueryCounters searchQueryCounters;
    final SearchQueryAggregationCategorizer searchQueryAggregationCategorizer;
    private static SearchQueryCategorizer instance;

    private SearchQueryCategorizer(MetricsRegistry metricsRegistry) {
        this.searchQueryCounters = new SearchQueryCounters(metricsRegistry);
        this.searchQueryAggregationCategorizer = new SearchQueryAggregationCategorizer(this.searchQueryCounters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchQueryCategorizer getInstance(MetricsRegistry metricsRegistry) {
        if (instance != null) return instance;
        Class<SearchQueryCategorizer> clazz = SearchQueryCategorizer.class;
        synchronized (SearchQueryCategorizer.class) {
            if (instance != null) return instance;
            instance = new SearchQueryCategorizer(metricsRegistry);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void consumeRecords(List<SearchQueryRecord> records) {
        for (SearchQueryRecord record : records) {
            this.categorize(record);
        }
    }

    public void categorize(SearchQueryRecord record) {
        SearchSourceBuilder source = (SearchSourceBuilder)record.getAttributes().get((Object)Attribute.SOURCE);
        Map<MetricType, Number> measurements = record.getMeasurements();
        QueryBuilder topLevelQueryBuilder = source.query();
        this.logQueryShape(topLevelQueryBuilder);
        this.incrementQueryTypeCounters(topLevelQueryBuilder, measurements);
        this.incrementQueryAggregationCounters(source.aggregations(), measurements);
        this.incrementQuerySortCounters(source.sorts(), measurements);
    }

    private void incrementQuerySortCounters(List<SortBuilder<?>> sorts, Map<MetricType, Number> measurements) {
        if (sorts != null && sorts.size() > 0) {
            for (SortBuilder<?> sortBuilder : sorts) {
                String sortOrder = sortBuilder.order().toString();
                this.searchQueryCounters.incrementSortCounter(1.0, Tags.create().addTag("sort_order", sortOrder), measurements);
            }
        }
    }

    private void incrementQueryAggregationCounters(AggregatorFactories.Builder aggregations, Map<MetricType, Number> measurements) {
        if (aggregations == null) {
            return;
        }
        this.searchQueryAggregationCategorizer.incrementSearchQueryAggregationCounters(aggregations.getAggregatorFactories(), measurements);
    }

    private void incrementQueryTypeCounters(QueryBuilder topLevelQueryBuilder, Map<MetricType, Number> measurements) {
        if (topLevelQueryBuilder == null) {
            return;
        }
        SearchQueryCategorizingVisitor searchQueryVisitor = new SearchQueryCategorizingVisitor(this.searchQueryCounters, measurements);
        topLevelQueryBuilder.visit((QueryBuilderVisitor)searchQueryVisitor);
    }

    private void logQueryShape(QueryBuilder topLevelQueryBuilder) {
        if (log.isTraceEnabled()) {
            if (topLevelQueryBuilder == null) {
                return;
            }
            QueryShapeVisitor shapeVisitor = new QueryShapeVisitor();
            topLevelQueryBuilder.visit((QueryBuilderVisitor)shapeVisitor);
            log.trace("Query shape : {}", (Object)shapeVisitor.prettyPrintTree("  "));
        }
    }

    public SearchQueryCounters getSearchQueryCounters() {
        return this.searchQueryCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Class<SearchQueryCategorizer> clazz = SearchQueryCategorizer.class;
        synchronized (SearchQueryCategorizer.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

