/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.shrink;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.action.ShrinkAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.WaitForMoveShardsStep;
import org.opensearch.indexmanagement.indexstatemanagement.util.StepUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionTimeout;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ShrinkActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0016J+\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017J)\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0019\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForMoveShardsStep;", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/ShrinkStep;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction;)V", "checkTimeOut", "", "stepContext", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "numShardsNotOnNode", "", "numShardsNotInSync", "nodeToMoveOnto", "", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;IILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGenericFailureMessage", "getNumShardsInSync", "shardStats", "", "Lorg/opensearch/action/admin/indices/stats/ShardStats;", "state", "Lorg/opensearch/cluster/ClusterState;", "indexName", "([Lorg/opensearch/action/admin/indices/stats/ShardStats;Lorg/opensearch/cluster/ClusterState;Ljava/lang/String;)I", "getNumShardsWithCopyOnNode", "clusterState", "getShardStats", "client", "Lorg/opensearch/client/Client;", "(Ljava/lang/String;Lorg/opensearch/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "wrappedExecute", "context", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nWaitForMoveShardsStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForMoveShardsStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForMoveShardsStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1774#2,4:149\n*S KotlinDebug\n*F\n+ 1 WaitForMoveShardsStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForMoveShardsStep\n*L\n83#1:149,4\n*E\n"})
public final class WaitForMoveShardsStep
extends ShrinkStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShrinkAction action;
    @NotNull
    public static final String name = "wait_for_move_shards_step";
    @NotNull
    public static final String FAILURE_MESSAGE = "Shrink failed when waiting for shards to move.";
    public static final long MOVE_SHARDS_TIMEOUT_IN_SECONDS = 43200L;

    public WaitForMoveShardsStep(@NotNull ShrinkAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, true, true, false);
        this.action = action;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object wrappedExecute(@NotNull StepContext var1_1, @NotNull Continuation<? super WaitForMoveShardsStep> var2_2) {
        if (!(var2_2 instanceof wrappedExecute.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.wrappedExecute((StepContext)null, (Continuation<? super WaitForMoveShardsStep>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = indexName;
                $continuation.label = 1;
                v0 = this.checkShrinkActionPropertiesAndRenewLock(context, (Continuation<? super ShrinkActionProperties>)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (WaitForMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = (ShrinkActionProperties)v0;
                if (v1 == null) {
                    return this;
                }
                localShrinkActionProperties = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = indexName;
                $continuation.L$3 = localShrinkActionProperties;
                $continuation.label = 2;
                v2 = this.getShardStats(indexName, context.getClient(), (Continuation<? super ShardStats[]>)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl47
            }
            case 2: {
                localShrinkActionProperties = (ShrinkActionProperties)$continuation.L$3;
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (WaitForMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl47:
                // 2 sources

                v3 = (ShardStats[])v2;
                if (v3 == null) {
                    return this;
                }
                shardStats = v3;
                v4 = context.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"context.clusterService.state()");
                numShardsInSync = this.getNumShardsInSync(shardStats, v4, indexName);
                nodeToMoveOnto = localShrinkActionProperties.getNodeName();
                var9_11 = context.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)var9_11, (String)"context.clusterService.state()");
                numShardsOnNode = this.getNumShardsWithCopyOnNode(shardStats, var9_11, nodeToMoveOnto);
                v5 = (IndexMetadata)context.getClusterService().state().getMetadata().getIndices().get(indexName);
                if (v5 == null) {
                    throw new IllegalStateException("numberOfShards should not be null".toString());
                }
                numPrimaryShards = v5.getNumberOfShards();
                if (numShardsOnNode >= numPrimaryShards && numShardsInSync >= numPrimaryShards) {
                    this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForMoveShardsStep.Companion.getSuccessMessage(nodeToMoveOnto))));
                    this.setStepStatus(Step.StepStatus.COMPLETED);
                } else {
                    numShardsNotOnNode = numPrimaryShards - numShardsOnNode;
                    numShardsNotInSync = numPrimaryShards - numShardsInSync;
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.label = 3;
                    v6 = this.checkTimeOut(context, numShardsNotOnNode, numShardsNotInSync, nodeToMoveOnto, (Continuation<? super Unit>)$continuation);
                    if (v6 == var14_5) {
                        return var14_5;
                    }
                }
                ** GOTO lbl81
            }
            case 3: {
                this = (WaitForMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl81:
                // 3 sources

                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int getNumShardsInSync(ShardStats[] shardStats, ClusterState state, String indexName) {
        IndexMetadata indexMetadata2 = (IndexMetadata)state.getMetadata().getIndices().get(indexName);
        if (indexMetadata2 == null) {
            throw new IllegalStateException("numberOfReplicas should not be null".toString());
        }
        int numReplicas = indexMetadata2.getNumberOfReplicas();
        IndexMetadata indexMetadata3 = (IndexMetadata)state.getMetadata().getIndices().get(indexName);
        Map inSyncAllocations = indexMetadata3 != null ? indexMetadata3.getInSyncAllocationIds() : null;
        int numShardsInSync = 0;
        for (ShardStats shard : shardStats) {
            ShardRouting routingInfo = shard.getShardRouting();
            if (!routingInfo.primary()) continue;
            Map map = inSyncAllocations;
            boolean bl = map != null && (map = (Set)map.get(routingInfo.getId())) != null ? map.size() == numReplicas + 1 : false;
            if (!bl) continue;
            ++numShardsInSync;
        }
        return numShardsInSync;
    }

    private final int getNumShardsWithCopyOnNode(ShardStats[] shardStats, ClusterState clusterState, String nodeToMoveOnto) {
        int n;
        Map shardIdStartedOnNode = new LinkedHashMap();
        for (ShardStats shard : shardStats) {
            String nodeName;
            ShardRouting routingInfo = shard.getShardRouting();
            int shardId = routingInfo.shardId().getId();
            if (Intrinsics.areEqual(shardIdStartedOnNode.get(shardId), (Object)true) || clusterState.getNodes().get(routingInfo.currentNodeId()).getName() == null) continue;
            Integer n2 = shardId;
            shardIdStartedOnNode.put(n2, Intrinsics.areEqual((Object)nodeName, (Object)nodeToMoveOnto) && routingInfo.started());
        }
        Iterable $this$count$iv = shardIdStartedOnNode.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getShardStats(String var1_1, Client var2_2, Continuation<? super ShardStats[]> var3_3) {
        if (!(var3_3 instanceof getShardStats.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaitForMoveShardsStep.access$getShardStats(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_7 = new String[]{indexName};
                v0 = new IndicesStatsRequest().indices(var6_7);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"IndicesStatsRequest().indices(indexName)");
                indexStatsRequests = (IndicesStatsRequest)v0;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesStatsResponse>, Unit>(indexStatsRequests){
                    final /* synthetic */ IndicesStatsRequest $indexStatsRequests;
                    {
                        this.$indexStatsRequests = $indexStatsRequests;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.stats(this.$indexStatsRequests, it);
                    }
                }, $continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (WaitForMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                if ((shardStats = (response = (IndicesStatsResponse)v1).getShards()) != null) break;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = ShrinkStep.cleanupAndFail$default(this, "Shrink action failed due to initial moving shards failure.", "Failed to move shards in shrink action as shard stats were null.", null, null, (Continuation)$continuation, 12, null);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl36
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl36:
                // 2 sources

                return null;
            }
        }
        return shardStats;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getGenericFailureMessage() {
        return FAILURE_MESSAGE;
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData actionMetaData2 = actionMetaData != null ? ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, null, null, null, this.getShrinkActionProperties(), null, 47, null), (int)63, null) : null;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.getStepStatus());
        Map<String, Object> map = this.getInfo();
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    private final Object checkTimeOut(StepContext stepContext, int numShardsNotOnNode, int numShardsNotInSync, String nodeToMoveOnto, Continuation<? super Unit> $completion) {
        long timeOutInSeconds;
        ManagedIndexMetaData managedIndexMetadata = stepContext.getMetadata();
        String indexName = managedIndexMetadata.getIndex();
        Duration duration = Duration.between(StepUtilsKt.getActionStartTime(managedIndexMetadata), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(getActionStartTi\u2026Metadata), Instant.now())");
        Duration timeSinceActionStarted = duration;
        ActionTimeout actionTimeout = this.action.getConfigTimeout();
        long l = actionTimeout != null && (actionTimeout = actionTimeout.getTimeout()) != null ? actionTimeout.getSeconds() : (timeOutInSeconds = 43200L);
        if (timeSinceActionStarted.toSeconds() > timeOutInSeconds) {
            Object object = ShrinkStep.cleanupAndFail$default(this, Companion.getTimeoutFailure(nodeToMoveOnto), Companion.getLoggedTimeoutError(indexName, numShardsNotOnNode, numShardsNotInSync), null, null, $completion, 12, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.getLogger().debug("Shrink action move shards step running on [" + indexName + "], [" + numShardsNotOnNode + "] shards need to be moved, [" + numShardsNotInSync + "] shards need an in sync replica.");
        this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getTimeoutDelay(nodeToMoveOnto))));
        this.setStepStatus(Step.StepStatus.CONDITION_NOT_MET);
        return Unit.INSTANCE;
    }

    public boolean isIdempotent() {
        return true;
    }

    public static final /* synthetic */ Object access$getShardStats(WaitForMoveShardsStep $this, String indexName, Client client, Continuation $completion) {
        return $this.getShardStats(indexName, client, (Continuation<? super ShardStats[]>)$completion);
    }

    public static final /* synthetic */ Object access$checkTimeOut(WaitForMoveShardsStep $this, StepContext stepContext, int numShardsNotOnNode, int numShardsNotInSync, String nodeToMoveOnto, Continuation $completion) {
        return $this.checkTimeOut(stepContext, numShardsNotOnNode, numShardsNotInSync, nodeToMoveOnto, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForMoveShardsStep$Companion;", "", "()V", "FAILURE_MESSAGE", "", "MOVE_SHARDS_TIMEOUT_IN_SECONDS", "", "name", "getLoggedTimeoutError", "index", "numShardsNotOnNode", "", "numShardsNotInSync", "getSuccessMessage", "node", "getTimeoutDelay", "getTimeoutFailure", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return "The shards successfully moved to " + node + ".";
        }

        @NotNull
        public final String getTimeoutFailure(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return "Shrink failed because it took too long to move shards to " + node;
        }

        @NotNull
        public final String getTimeoutDelay(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return "Shrink delayed because it took too long to move shards to " + node;
        }

        @NotNull
        public final String getLoggedTimeoutError(@NotNull String index2, int numShardsNotOnNode, int numShardsNotInSync) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Shrink Action move shards failed on [" + index2 + "], the action timed out with [" + numShardsNotOnNode + "] shards not yet moved and [" + numShardsNotInSync + "] shards without an in sync replica.";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

