/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.preprocessor;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.preprocessor.transform.WeightedTransformer;
import com.amazon.randomcutforest.statistics.Deviation;
import java.util.Arrays;

public class InitialSegmentPreprocessor
extends Preprocessor {
    public InitialSegmentPreprocessor(Preprocessor.Builder<?> builder) {
        super(builder);
        this.initialValues = new double[this.startNormalization][];
        this.initialTimeStamps = new long[this.startNormalization];
    }

    protected void storeInitial(double[] inputPoint, long timestamp, int[] missingValues) {
        this.initialTimeStamps[this.valuesSeen] = timestamp;
        int length = this.inputLength + (missingValues == null ? 0 : missingValues.length);
        double[] temp = new double[length];
        System.arraycopy(inputPoint, 0, temp, 0, this.inputLength);
        if (missingValues != null) {
            for (int i = 0; i < length - this.inputLength; ++i) {
                temp[this.inputLength + i] = missingValues[i];
            }
        }
        this.initialValues[this.valuesSeen] = temp;
        ++this.valuesSeen;
    }

    double prepareInitialInput() {
        int j;
        int i;
        int totalMissing = 0;
        boolean[][] missing = new boolean[this.initialValues.length][this.inputLength];
        for (i = 0; i < this.initialValues.length; ++i) {
            Arrays.fill(missing[i], false);
            int length = this.initialValues[i].length - this.inputLength;
            for (int j2 = 0; j2 < length; ++j2) {
                ++totalMissing;
                missing[i][(int)Math.round((double)this.initialValues[i][this.inputLength + j2])] = true;
            }
        }
        if (this.imputationMethod == ImputationMethod.ZERO || this.imputationMethod == ImputationMethod.FIXED_VALUES) {
            for (i = 0; i < this.initialValues.length - 1; ++i) {
                for (j = 0; j < this.inputLength; ++j) {
                    this.initialValues[i][j] = !missing[i][j] ? this.initialValues[i][j] : this.defaultFill[j];
                }
            }
        } else {
            boolean[] startingValuesSet = new boolean[this.inputLength];
            for (j = 0; j < this.inputLength; ++j) {
                int y;
                int next;
                startingValuesSet[j] = false;
                for (next = 0; next < this.initialValues.length && missing[next][j]; ++next) {
                }
                boolean bl = startingValuesSet[j] = next < this.initialValues.length;
                if (startingValuesSet[j]) {
                    this.initialValues[0][j] = this.initialValues[next][j];
                    missing[0][j] = false;
                    int start = 0;
                    while (start < this.initialValues.length - 1) {
                        int end;
                        for (end = start + 1; end < this.initialValues.length && missing[end][j]; ++end) {
                        }
                        if (end < this.initialValues.length && end > start + 1) {
                            for (int y2 = start + 1; y2 < end; ++y2) {
                                double factor = (1.0 * (double)this.initialTimeStamps[start] - (double)this.initialTimeStamps[y2]) / (double)(this.initialTimeStamps[start] - this.initialTimeStamps[end]);
                                this.initialValues[y2][j] = factor * this.initialValues[start][j] + (1.0 - factor) * this.initialValues[end][j];
                            }
                        }
                        start = end;
                    }
                    continue;
                }
                if (this.defaultFill != null) {
                    for (y = 0; y < this.initialValues.length; ++y) {
                        this.initialValues[y][j] = this.defaultFill[j];
                    }
                    continue;
                }
                for (y = 0; y < this.initialValues.length; ++y) {
                    this.initialValues[y][j] = 0.0;
                }
            }
        }
        for (int i2 = 0; i2 < this.initialValues.length; ++i2) {
            this.initialValues[i2] = Arrays.copyOf(this.initialValues[i2], this.inputLength);
        }
        return 1.0 - 1.0 * (double)totalMissing / (double)this.initialValues.length;
    }

    @Override
    public void update(double[] point, float[] rcfPoint, long timestamp, int[] missing, RandomCutForest forest) {
        if (this.valuesSeen < this.startNormalization) {
            this.storeInitial(point, timestamp, missing);
            if (this.valuesSeen == this.startNormalization) {
                this.dischargeInitial(forest);
            }
            return;
        }
        super.update(point, rcfPoint, timestamp, missing, forest);
    }

    protected Deviation[] getInitialDeviations() {
        int j;
        int i;
        Deviation[] tempList = new Deviation[WeightedTransformer.NUMBER_OF_STATS * this.inputLength];
        for (int j2 = 0; j2 < WeightedTransformer.NUMBER_OF_STATS * this.inputLength; ++j2) {
            tempList[j2] = new Deviation(this.transformDecay);
        }
        for (i = 0; i < this.initialValues.length; ++i) {
            for (j = 0; j < this.inputLength; ++j) {
                tempList[j].update(this.initialValues[i][j]);
                double value = i == 0 ? 0.0 : this.initialValues[i][j] - this.initialValues[i - 1][j];
                tempList[j + this.inputLength].update(value);
            }
        }
        for (i = 0; i < this.initialValues.length; ++i) {
            for (j = 0; j < this.inputLength; ++j) {
                tempList[j + 2 * this.inputLength].update(tempList[j].getDeviation());
                tempList[j + 3 * this.inputLength].update(tempList[j + this.inputLength].getMean());
                tempList[j + 4 * this.inputLength].update(tempList[j + this.inputLength].getDeviation());
            }
        }
        return tempList;
    }

    protected void dischargeInitial(RandomCutForest forest) {
        Deviation tempTimeDeviation = new Deviation();
        for (int i = 0; i < this.initialTimeStamps.length - 1; ++i) {
            tempTimeDeviation.update(this.initialTimeStamps[i + 1] - this.initialTimeStamps[i]);
        }
        double timeFactor = 1.0 + tempTimeDeviation.getDeviation();
        double quality = this.prepareInitialInput();
        Deviation[] deviations = this.getInitialDeviations();
        Arrays.fill(this.previousTimeStamps, this.initialTimeStamps[0]);
        for (int i = 0; i < this.valuesSeen; ++i) {
            float[] scaledInput = this.getScaledInput(this.initialValues[i], this.initialTimeStamps[i], deviations, timeFactor);
            this.updateState(this.initialValues[i], scaledInput, this.initialTimeStamps[i], this.previousTimeStamps[this.shingleSize - 1], null);
            this.dataQuality[0].update(quality);
            if (forest == null) continue;
            if (forest.isInternalShinglingEnabled()) {
                forest.update(scaledInput);
                continue;
            }
            forest.update(this.lastShingledPoint);
        }
        this.initialTimeStamps = null;
        this.initialValues = null;
    }
}

