/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.Configuration;

public class MLConfig
implements ToXContentObject,
Writeable {
    public static final String TYPE_FIELD = "type";
    public static final String CONFIG_TYPE_FIELD = "config_type";
    public static final String CONFIGURATION_FIELD = "configuration";
    public static final String ML_CONFIGURATION_FIELD = "ml_configuration";
    public static final String CREATE_TIME_FIELD = "create_time";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private String type;
    private Configuration configuration;
    private final Instant createTime;
    private Instant lastUpdateTime;

    public MLConfig(String type, Configuration configuration, Instant createTime, Instant lastUpdateTime) {
        this.type = type;
        this.configuration = configuration;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
    }

    public MLConfig(StreamInput input) throws IOException {
        this.type = input.readOptionalString();
        if (input.readBoolean()) {
            this.configuration = new Configuration(input);
        }
        this.createTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.type);
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createTime);
        out.writeOptionalInstant(this.lastUpdateTime);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.type != null) {
            builder.field(CONFIG_TYPE_FIELD, this.type);
        }
        if (this.configuration != null) {
            builder.field(ML_CONFIGURATION_FIELD, (ToXContent)this.configuration);
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME_FIELD, this.createTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        return builder.endObject();
    }

    public static MLConfig fromStream(StreamInput in) throws IOException {
        MLConfig mlConfig = new MLConfig(in);
        return mlConfig;
    }

    public static MLConfig parse(XContentParser parser) throws IOException {
        String type = null;
        String configType = null;
        Configuration configuration = null;
        Configuration mlConfiguration = null;
        Instant createTime = null;
        Instant lastUpdateTime = null;
        Instant lastUpdatedTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block18;
                }
                case "config_type": {
                    configType = parser.text();
                    continue block18;
                }
                case "configuration": {
                    configuration = Configuration.parse(parser);
                    continue block18;
                }
                case "ml_configuration": {
                    mlConfiguration = Configuration.parse(parser);
                    continue block18;
                }
                case "create_time": {
                    createTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return MLConfig.builder().type(configType == null ? type : configType).configuration(mlConfiguration == null ? configuration : mlConfiguration).createTime(createTime).lastUpdateTime(lastUpdatedTime == null ? lastUpdateTime : lastUpdatedTime).build();
    }

    @Generated
    public static MLConfigBuilder builder() {
        return new MLConfigBuilder();
    }

    @Generated
    public MLConfigBuilder toBuilder() {
        return new MLConfigBuilder().type(this.type).configuration(this.configuration).createTime(this.createTime).lastUpdateTime(this.lastUpdateTime);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLConfig)) {
            return false;
        }
        MLConfig other = (MLConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Instant this$createTime = this.getCreateTime();
        Instant other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        return !(this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Instant $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        return result;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public static class MLConfigBuilder {
        @Generated
        private String type;
        @Generated
        private Configuration configuration;
        @Generated
        private Instant createTime;
        @Generated
        private Instant lastUpdateTime;

        @Generated
        MLConfigBuilder() {
        }

        @Generated
        public MLConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLConfigBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MLConfigBuilder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public MLConfigBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLConfig build() {
            return new MLConfig(this.type, this.configuration, this.createTime, this.lastUpdateTime);
        }

        @Generated
        public String toString() {
            return "MLConfig.MLConfigBuilder(type=" + this.type + ", configuration=" + String.valueOf(this.configuration) + ", createTime=" + String.valueOf(this.createTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ")";
        }
    }
}

