/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.opensearch.analysis.common.AbstractCompoundWordTokenFilterFactory;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.Analysis;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final HyphenationTree hyphenationTree;

    HyphenationCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, env, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new IllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        Path hyphenationPatternsFile = Analysis.resolveAnalyzerPath((Environment)env, (String)hyphenationPatternsPath);
        try {
            InputStream in = Files.newInputStream(hyphenationPatternsFile, new OpenOption[0]);
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)new InputSource(in));
        }
        catch (Exception e) {
            LogManager.getLogger(HyphenationCompoundWordTokenFilterFactory.class).error("Exception while reading hyphenation_patterns_path ", (Throwable)e);
            throw new IllegalArgumentException("Exception while reading hyphenation_patterns_path.");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new HyphenationCompoundWordTokenFilter(tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

