/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import org.apache.commons.lang3.ArrayUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.Strings;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestHandlerUtils {
    private static final String PATH_TO_CREDENTIAL_FIELD = "workflows.provision.nodes.user_inputs.credential";
    private static final String[] DASHBOARD_EXCLUDES = new String[]{"user", "ui_metadata", "workflows.provision.nodes.user_inputs.credential"};
    private static final String[] EXCLUDES = new String[]{"user", "workflows.provision.nodes.user_inputs.credential"};

    private RestHandlerUtils() {
    }

    public static FetchSourceContext getSourceContext(User user, SearchSourceBuilder searchSourceBuilder) {
        if (searchSourceBuilder.fetchSource() != null) {
            String[] newArray = (String[])ArrayUtils.addAll((Object[])searchSourceBuilder.fetchSource().excludes(), (Object[])DASHBOARD_EXCLUDES);
            return new FetchSourceContext(true, searchSourceBuilder.fetchSource().includes(), newArray);
        }
        if (ParseUtils.isAdmin(user)) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, new String[]{PATH_TO_CREDENTIAL_FIELD});
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, EXCLUDES);
    }
}

