/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

public final class Hex {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static String toHexString(byte[] block) {
        return Hex.toHexString(block, 0, block.length);
    }

    public static String toHexString(byte[] block, int start, int end) {
        if (block == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            byte aBlock = block[i];
            int high = (aBlock & 0xF0) >> 4;
            int low = aBlock & 0xF;
            buf.append(HEX_CHARS[high]);
            buf.append(HEX_CHARS[low]);
        }
        return buf.toString();
    }

    public static byte[] toByteArray(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new NumberFormatException("Invalid Hex String");
        }
        byte[] ret = new byte[len / 2];
        for (int i = 0; i < len / 2; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }
}

