/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.property;

import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperty;
import com.oracle.labs.mlrg.olcut.config.property.ImmutableGlobalProperties;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;

public class GlobalProperties
extends ImmutableGlobalProperties {
    public GlobalProperties() {
    }

    public GlobalProperties(GlobalProperties globalProperties) {
        super(globalProperties);
    }

    public final void importSystemProperties() {
        Properties props = AccessController.doPrivileged(System::getProperties);
        this.importProperties(props);
    }

    void importProperties(Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String value;
            String param = e.getKey().toString();
            String string = value = e.getValue() == null ? "null" : e.getValue().toString();
            String testValue = "${" + param + "}";
            Matcher m = GlobalProperty.globalSymbolPattern.matcher(testValue);
            if (!m.matches()) continue;
            this.map.put(param, new GlobalProperty(value));
        }
    }

    public void setValue(String propertyName, String value) throws PropertyException {
        this.setValue(propertyName, new GlobalProperty(value));
    }

    public void setValue(String propertyName, GlobalProperty value) throws PropertyException {
        String testValue = "${" + propertyName + "}";
        Matcher m = GlobalProperty.globalSymbolPattern.matcher(testValue);
        if (!m.matches()) {
            throw new PropertyException("GlobalProperties", propertyName, "Does not conform to the GlobalProperty regex");
        }
        this.map.put(propertyName, value);
    }

    public void putAll(GlobalProperties otherGP) {
        for (Map.Entry<String, GlobalProperty> p : otherGP) {
            this.map.put(p.getKey(), p.getValue());
        }
    }

    public void remove(String key) {
        this.map.remove(key);
    }
}

