/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.io;

import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MarshalledProvenance;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class ObjectMarshalledProvenance
implements MarshalledProvenance {
    private final Map<String, FlatMarshalledProvenance> map;
    private final String objectName;
    private final String objectClassName;
    private final String provenanceClassName;

    public ObjectMarshalledProvenance(String objectName, Map<String, FlatMarshalledProvenance> map, String objectClassName, String provenanceClassName) {
        this.objectName = objectName;
        this.map = Collections.unmodifiableMap(map);
        this.objectClassName = objectClassName;
        this.provenanceClassName = provenanceClassName;
    }

    public String getName() {
        return this.objectName;
    }

    public Map<String, FlatMarshalledProvenance> getMap() {
        return this.map;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public String getProvenanceClassName() {
        return this.provenanceClassName;
    }

    public String toString() {
        return "ObjectMarshalledProvenance{map=" + this.map + ", objectName='" + this.objectName + '\'' + ", objectClassName='" + this.objectClassName + '\'' + ", provenanceClassName='" + this.provenanceClassName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectMarshalledProvenance)) {
            return false;
        }
        ObjectMarshalledProvenance that = (ObjectMarshalledProvenance)o;
        return this.map.equals(that.map) && this.objectName.equals(that.objectName) && this.objectClassName.equals(that.objectClassName) && this.provenanceClassName.equals(that.provenanceClassName);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.objectName, this.objectClassName, this.provenanceClassName);
    }
}

