/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Map;
import org.opensearch.sql.data.model.ExprMissingValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public interface ExprValue
extends Serializable,
Comparable<ExprValue> {
    public Object value();

    public ExprType type();

    default public boolean isNull() {
        return false;
    }

    default public boolean isMissing() {
        return false;
    }

    default public boolean isNumber() {
        return false;
    }

    default public boolean isDateTime() {
        return false;
    }

    default public BindingTuple bindingTuples() {
        return BindingTuple.EMPTY;
    }

    default public Byte byteValue() {
        throw new ExpressionEvaluationException("invalid to get byteValue from value of type " + String.valueOf(this.type()));
    }

    default public Short shortValue() {
        throw new ExpressionEvaluationException("invalid to get shortValue from value of type " + String.valueOf(this.type()));
    }

    default public Integer integerValue() {
        throw new ExpressionEvaluationException("invalid to get integerValue from value of type " + String.valueOf(this.type()));
    }

    default public Long longValue() {
        throw new ExpressionEvaluationException("invalid to get longValue from value of type " + String.valueOf(this.type()));
    }

    default public Float floatValue() {
        throw new ExpressionEvaluationException("invalid to get floatValue from value of type " + String.valueOf(this.type()));
    }

    default public Double doubleValue() {
        throw new ExpressionEvaluationException("invalid to get doubleValue from value of type " + String.valueOf(this.type()));
    }

    default public String stringValue() {
        throw new ExpressionEvaluationException("invalid to get stringValue from value of type " + String.valueOf(this.type()));
    }

    default public Boolean booleanValue() {
        throw new ExpressionEvaluationException("invalid to get booleanValue from value of type " + String.valueOf(this.type()));
    }

    default public Instant timestampValue() {
        throw new ExpressionEvaluationException("invalid to get timestampValue from value of type " + String.valueOf(this.type()));
    }

    default public LocalTime timeValue() {
        throw new ExpressionEvaluationException("invalid to get timeValue from value of type " + String.valueOf(this.type()));
    }

    default public LocalDate dateValue() {
        throw new ExpressionEvaluationException("invalid to get dateValue from value of type " + String.valueOf(this.type()));
    }

    default public LocalDateTime datetimeValue() {
        throw new ExpressionEvaluationException("invalid to get datetimeValue from value of type " + String.valueOf(this.type()));
    }

    default public TemporalAmount intervalValue() {
        throw new ExpressionEvaluationException("invalid to get intervalValue from value of type " + String.valueOf(this.type()));
    }

    default public Map<String, ExprValue> tupleValue() {
        throw new ExpressionEvaluationException("invalid to get tupleValue from value of type " + String.valueOf(this.type()));
    }

    default public List<ExprValue> collectionValue() {
        throw new ExpressionEvaluationException("invalid to get collectionValue from value of type " + String.valueOf(this.type()));
    }

    default public ExprValue keyValue(String key) {
        return ExprMissingValue.of();
    }
}

