/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.List;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class MaxAggregator
extends Aggregator<MaxState> {
    public MaxAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.MAX.getName(), arguments, returnType);
    }

    @Override
    public MaxState create() {
        return new MaxState();
    }

    @Override
    protected MaxState iterate(ExprValue value, MaxState state) {
        state.max(value);
        return state;
    }

    public String toString() {
        return String.format("max(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class MaxState
    implements AggregationState {
        private ExprValue maxResult = ExprValueUtils.LITERAL_NULL;

        MaxState() {
        }

        public void max(ExprValue value) {
            this.maxResult = this.maxResult.isNull() ? value : (this.maxResult.compareTo(value) > 0 ? this.maxResult : value);
        }

        @Override
        public ExprValue result() {
            return this.maxResult;
        }
    }
}

