/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.ExpressionNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class ConstantNode
extends ExpressionNode {
    private Object constant;

    public void setConstant(Object constant) {
        this.constant = constant;
    }

    public Object getConstant() {
        return this.constant;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitConstant(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
    }

    public ConstantNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        if (this.constant instanceof String) {
            methodWriter.push((String)this.constant);
        } else if (this.constant instanceof Double) {
            methodWriter.push((Double)this.constant);
        } else if (this.constant instanceof Float) {
            methodWriter.push(((Float)this.constant).floatValue());
        } else if (this.constant instanceof Long) {
            methodWriter.push((Long)this.constant);
        } else if (this.constant instanceof Integer) {
            methodWriter.push((Integer)this.constant);
        } else if (this.constant instanceof Character) {
            methodWriter.push(((Character)this.constant).charValue());
        } else if (this.constant instanceof Short) {
            methodWriter.push(((Short)this.constant).shortValue());
        } else if (this.constant instanceof Byte) {
            methodWriter.push(((Byte)this.constant).byteValue());
        } else if (this.constant instanceof Boolean) {
            methodWriter.push((Boolean)this.constant);
        } else {
            throw new IllegalStateException("unexpected constant [" + String.valueOf(this.constant) + "]");
        }
    }
}

