/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import javax.crypto.SecretKey;

public class DataKey<M extends MasterKey<M>>
implements EncryptedDataKey {
    private final byte[] providerInformation_;
    private final byte[] encryptedDataKey_;
    private final SecretKey key_;
    private final M masterKey_;

    public DataKey(SecretKey key, byte[] encryptedDataKey, byte[] providerInformation, M masterKey) {
        this.key_ = key;
        this.encryptedDataKey_ = (byte[])encryptedDataKey.clone();
        this.providerInformation_ = (byte[])providerInformation.clone();
        this.masterKey_ = masterKey;
    }

    public SecretKey getKey() {
        return this.key_;
    }

    @Override
    public String getProviderId() {
        return ((MasterKey)this.masterKey_).getProviderId();
    }

    @Override
    public byte[] getProviderInformation() {
        return (byte[])this.providerInformation_.clone();
    }

    @Override
    public byte[] getEncryptedDataKey() {
        return (byte[])this.encryptedDataKey_.clone();
    }

    public M getMasterKey() {
        return this.masterKey_;
    }
}

