/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.annotation.Generated;

public class Sample
implements ToXContentObject {
    private final double[] data;
    private final Instant dataStartTime;
    private final Instant dataEndTime;

    public Sample(double[] data, Instant dataStartTime, Instant dataEndTime) {
        this.data = data;
        this.dataStartTime = dataStartTime;
        this.dataEndTime = dataEndTime;
    }

    public Sample() {
        this.data = new double[0];
        this.dataStartTime = this.dataEndTime = Instant.MIN;
    }

    public double[] getValueList() {
        return this.data;
    }

    public Instant getDataStartTime() {
        return this.dataStartTime;
    }

    public Instant getDataEndTime() {
        return this.dataEndTime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.data != null) {
            xContentBuilder.array("value_list", this.data);
        }
        if (this.dataStartTime != null && this.dataStartTime != Instant.MIN) {
            xContentBuilder.field("data_start_time", this.dataStartTime.toEpochMilli());
        }
        if (this.dataEndTime != null && this.dataEndTime != Instant.MIN) {
            xContentBuilder.field("data_end_time", this.dataEndTime.toEpochMilli());
        }
        return xContentBuilder.endObject();
    }

    public static Sample extractSample(Map<String, Object> map) {
        Long dataEndTimeLong = (Long)map.get("data_end_time");
        Long dataStartTimeLong = (Long)map.get("data_start_time");
        List valueList = (List)map.get("value_list");
        if (dataEndTimeLong == null && dataStartTimeLong == null && valueList == null) {
            return null;
        }
        double[] data = valueList.stream().mapToDouble(Double::doubleValue).toArray();
        Instant dataEndTime = Instant.ofEpochMilli(dataEndTimeLong);
        Instant dataStartTime = Instant.ofEpochMilli(dataStartTimeLong);
        return new Sample(data, dataStartTime, dataEndTime);
    }

    public boolean isInvalid() {
        return this.dataStartTime.compareTo(Instant.MIN) == 0 || this.dataEndTime.compareTo(Instant.MIN) == 0;
    }

    public String toString() {
        return "Sample [data=" + Arrays.toString(this.data) + ", dataStartTime=" + String.valueOf(this.dataStartTime) + ", dataEndTime=" + String.valueOf(this.dataEndTime) + "]";
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample sample = (Sample)o;
        return Arrays.equals(this.data, sample.data) && this.dataStartTime.truncatedTo(ChronoUnit.MILLIS).equals(sample.dataStartTime.truncatedTo(ChronoUnit.MILLIS)) && this.dataEndTime.truncatedTo(ChronoUnit.MILLIS).equals(sample.dataEndTime.truncatedTo(ChronoUnit.MILLIS));
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.data, this.dataStartTime.truncatedTo(ChronoUnit.MILLIS), this.dataEndTime.truncatedTo(ChronoUnit.MILLIS)});
    }
}

