/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.stats.Stats;
import org.opensearch.timeseries.stats.TimeSeriesStat;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.transport.StatsResponse;
import org.opensearch.timeseries.transport.StatsTimeSeriesResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;

public abstract class BaseStatsTransportAction
extends HandledTransportAction<StatsRequest, StatsTimeSeriesResponse> {
    public final Logger logger = LogManager.getLogger(BaseStatsTransportAction.class);
    protected final Client client;
    protected final Stats stats;
    protected final ClusterService clusterService;

    public BaseStatsTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, Stats stats, ClusterService clusterService, String statsAction) {
        super(statsAction, transportService, actionFilters, StatsRequest::new);
        this.client = client;
        this.stats = stats;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, StatsRequest request, ActionListener<StatsTimeSeriesResponse> actionListener) {
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonMessages.FAIL_TO_GET_STATS);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getStats(this.client, (ActionListener<StatsTimeSeriesResponse>)listener, request);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    public void getStats(Client client, ActionListener<StatsTimeSeriesResponse> listener, StatsRequest statsRequest) {
        MultiResponsesDelegateActionListener<StatsResponse> delegateListener = new MultiResponsesDelegateActionListener<StatsResponse>(this.getRestStatsListener(listener), 2, "Unable to return Stats", false);
        this.getClusterStats(client, delegateListener, statsRequest);
        this.getNodeStats(client, delegateListener, statsRequest);
    }

    public ActionListener<StatsResponse> getRestStatsListener(ActionListener<StatsTimeSeriesResponse> listener) {
        return ActionListener.wrap(statsResponse -> listener.onResponse((Object)new StatsTimeSeriesResponse((StatsResponse)statsResponse)), exception -> listener.onFailure((Exception)new OpenSearchStatusException(exception.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
    }

    protected Map<String, Object> getClusterStatsMap(StatsRequest statsRequest) {
        HashMap<String, Object> clusterStats = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = statsRequest.getStatsToBeRetrieved();
        this.stats.getClusterStats().entrySet().stream().filter(s -> statsToBeRetrieved.contains(s.getKey())).forEach(s -> clusterStats.put((String)s.getKey(), ((TimeSeriesStat)s.getValue()).getValue()));
        return clusterStats;
    }

    protected abstract void getClusterStats(Client var1, MultiResponsesDelegateActionListener<StatsResponse> var2, StatsRequest var3);

    protected abstract void getNodeStats(Client var1, MultiResponsesDelegateActionListener<StatsResponse> var2, StatsRequest var3);
}

