/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.example;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import java.util.HashMap;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.ImmutableDataset;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.SimpleDataSourceProvenance;
import org.tribuo.regression.RegressionFactory;
import org.tribuo.regression.Regressor;

public abstract class RegressionDataGenerator {
    public static final String firstDimensionName = "dim1";
    public static final String secondDimensionName = "dim2";
    public static final String thirdDimensionName = "dim3";
    public static final String SINGLE_DIM_NAME = "REGRESSOR";
    private static final RegressionFactory REGRESSION_FACTORY = new RegressionFactory();
    private static final String[] dimensionNames = new String[]{"dim1", "dim2"};
    private static final String[] threeNames = new String[]{"dim1", "dim2", "dim3"};

    private RegressionDataGenerator() {
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> multiDimDenseTrainTest() {
        return RegressionDataGenerator.multiDimDenseTrainTest(-1.0);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> multiDimDenseTrainTest(double negate) {
        MutableDataset train = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.0, -5.0}), names, values));
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.8, -5.8}), (String[])names.clone(), values));
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{8.0, -8.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), (String[])names.clone(), values));
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), (String[])names.clone(), values));
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), (String[])names.clone(), values));
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), (String[])names.clone(), values));
        MutableDataset test = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.1, -5.1}), (String[])names.clone(), values));
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), (String[])names.clone(), values));
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), (String[])names.clone(), values));
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), (String[])names.clone(), values));
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> threeDimDenseTrainTest(double negate, boolean remapIndices) {
        MutableDataset train = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{5.0, -5.0, 0.0}), names, values));
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{5.8, -5.8, 1.0}), names, values));
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{8.0, -8.0, 9.0}), names, values));
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{10.0, -10.0, 0.5}), names, values));
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{10.0, -10.0, 0.5}), names, values));
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{10.0, -10.0, 0.5}), names, values));
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{20.0, -20.0, 5.0}), names, values));
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{20.0, -20.0, 4.0}), names, values));
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{20.0, -20.0, 2.0}), names, values));
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{50.0, -50.0, 10.0}), names, values));
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{50.0, -50.0, 15.0}), names, values));
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{50.0, -50.0, 10.0}), names, values));
        MutableDataset test = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{5.1, -5.1, 1.2}), names, values));
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{10.0, -10.0, 0.5}), names, values));
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{20.0, -20.0, 6.0}), names, values));
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Regressor(threeNames, new double[]{50.0, -50.0, 10.0}), names, values));
        if (remapIndices) {
            HashMap<Regressor, Integer> mapping = new HashMap<Regressor, Integer>();
            mapping.put(new Regressor.DimensionTuple(firstDimensionName, Double.NaN), 2);
            mapping.put(new Regressor.DimensionTuple(secondDimensionName, Double.NaN), 0);
            mapping.put(new Regressor.DimensionTuple(thirdDimensionName, Double.NaN), 1);
            ImmutableOutputInfo<Regressor> newInfo = REGRESSION_FACTORY.constructInfoForExternalModel(mapping);
            ImmutableDataset newTrain = ImmutableDataset.copyDataset((Dataset)train, (ImmutableFeatureMap)train.getFeatureIDMap(), newInfo);
            ImmutableDataset newTest = ImmutableDataset.copyDataset((Dataset)test, (ImmutableFeatureMap)train.getFeatureIDMap(), newInfo);
            return new Pair((Object)newTrain, (Object)newTest);
        }
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> multiDimSparseTrainTest() {
        return RegressionDataGenerator.multiDimSparseTrainTest(-1.0);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> multiDimSparseTrainTest(double negate) {
        MutableDataset train = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.0, -5.0}), names, values));
        names = new String[]{"B", "D", "F", "H"};
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.8, -5.8}), names, values));
        names = new String[]{"A", "J", "D", "M"};
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{8.0, -8.0}), names, values));
        names = new String[]{"C", "E", "F", "H"};
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), names, values));
        names = new String[]{"E", "G", "F", "I"};
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), names, values));
        names = new String[]{"J", "K", "C", "E"};
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), names, values));
        names = new String[]{"E", "A", "K", "J"};
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), names, values));
        names = new String[]{"B", "C", "E", "H"};
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), names, values));
        names = new String[]{"A", "M", "I", "J"};
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), names, values));
        names = new String[]{"Z", "A", "B", "C"};
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), names, values));
        names = new String[]{"K", "V", "E", "D"};
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), names, values));
        names = new String[]{"B", "G", "E", "A"};
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), names, values));
        MutableDataset test = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY), (OutputFactory)REGRESSION_FACTORY);
        names = new String[]{"AA", "B", "C", "D"};
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{5.5, -5.5}), names, values));
        names = new String[]{"B", "BB", "F", "E"};
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{10.0, -10.0}), names, values));
        names = new String[]{"B", "E", "G", "H"};
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{20.0, -20.0}), names, values));
        names = new String[]{"B", "CC", "DD", "EE"};
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Regressor(dimensionNames, new double[]{50.0, -50.0}), names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Example<Regressor> invalidMultiDimSparseExample() {
        return new ArrayExample((Output)new Regressor(dimensionNames, new double[]{1.0, -1.0}), new String[]{"1", "5", "8"}, new double[]{1.0, 5.0, 8.0});
    }

    public static Example<Regressor> emptyMultiDimExample() {
        return new ArrayExample((Output)new Regressor(dimensionNames, new double[]{1.0, -1.0}), new String[0], new double[0]);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> denseTrainTest() {
        return RegressionDataGenerator.denseTrainTest(-1.0);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> denseTrainTest(double negate) {
        SimpleDataSourceProvenance provenance = new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY);
        MutableDataset train = new MutableDataset((DataProvenance)provenance, (OutputFactory)REGRESSION_FACTORY);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.0), names, values));
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.8), names, values));
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 8.0), names, values));
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        SimpleDataSourceProvenance testProvenance = new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY);
        MutableDataset test = new MutableDataset((DataProvenance)testProvenance, (OutputFactory)REGRESSION_FACTORY);
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.1), names, values));
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> sparseTrainTest() {
        return RegressionDataGenerator.sparseTrainTest(-1.0);
    }

    public static Pair<Dataset<Regressor>, Dataset<Regressor>> sparseTrainTest(double negate) {
        SimpleDataSourceProvenance provenance = new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY);
        MutableDataset train = new MutableDataset((DataProvenance)provenance, (OutputFactory)REGRESSION_FACTORY);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.0), names, values));
        names = new String[]{"B", "D", "F", "H"};
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.8), names, values));
        names = new String[]{"A", "J", "D", "M"};
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 8.0), names, values));
        names = new String[]{"C", "E", "F", "H"};
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        names = new String[]{"E", "G", "F", "I"};
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        names = new String[]{"J", "K", "C", "E"};
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        names = new String[]{"E", "A", "K", "J"};
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        names = new String[]{"B", "C", "E", "H"};
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        names = new String[]{"A", "M", "I", "J"};
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        names = new String[]{"Z", "A", "B", "C"};
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        names = new String[]{"K", "V", "E", "D"};
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        names = new String[]{"B", "G", "E", "A"};
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        SimpleDataSourceProvenance testProvenance = new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)REGRESSION_FACTORY);
        MutableDataset test = new MutableDataset((DataProvenance)testProvenance, (OutputFactory)REGRESSION_FACTORY);
        names = new String[]{"AA", "B", "C", "D"};
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 5.5), names, values));
        names = new String[]{"B", "BB", "F", "E"};
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 10.0), names, values));
        names = new String[]{"B", "E", "G", "H"};
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 20.0), names, values));
        names = new String[]{"B", "CC", "DD", "EE"};
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 50.0), names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Example<Regressor> invalidSparseExample() {
        return new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 1.0), new String[]{"1", "5", "8"}, new double[]{1.0, 5.0, 8.0});
    }

    public static Example<Regressor> emptyExample() {
        return new ArrayExample((Output)new Regressor(SINGLE_DIM_NAME, 1.0), new String[0], new double[0]);
    }
}

