/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.upgrade;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.opensearch.cli.Terminal;
import org.opensearch.common.collect.Tuple;
import org.opensearch.upgrade.TaskInput;
import org.opensearch.upgrade.UpgradeTask;

class InstallPluginsTask
implements UpgradeTask {
    private static final String ERROR_MSG = "Error installing plugin %s. Please install it manually.";
    static final Set<String> OFFICIAL_PLUGINS;

    InstallPluginsTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        if (taskInput.getPlugins() == null || taskInput.getPlugins().isEmpty()) {
            return;
        }
        terminal.println("Installing core plugins ...");
        ArrayList<String> manualPlugins = new ArrayList<String>();
        for (String plugin : taskInput.getPlugins()) {
            if (OFFICIAL_PLUGINS.contains(plugin)) {
                this.executeInstallPluginCommand(plugin, taskInput, terminal);
                continue;
            }
            manualPlugins.add(plugin);
        }
        if (!manualPlugins.isEmpty()) {
            terminal.println("Please install the following custom plugins manually: " + String.valueOf(manualPlugins));
        }
        terminal.println("Success!" + System.lineSeparator());
    }

    void executeInstallPluginCommand(String plugin, TaskInput taskInput, Terminal terminal) {
        ProcessBuilder processBuilder = this.getProcessBuilderBasedOnOS(plugin, taskInput);
        try {
            Process process = processBuilder.inheritIO().start();
            if (process.waitFor() != 0) {
                terminal.errorPrint(Terminal.Verbosity.NORMAL, String.format(Locale.getDefault(), ERROR_MSG, plugin));
            }
        }
        catch (IOException | InterruptedException e) {
            terminal.errorPrint(Terminal.Verbosity.NORMAL, String.format(Locale.getDefault(), ERROR_MSG, plugin) + e.getMessage());
        }
    }

    ProcessBuilder getProcessBuilderBasedOnOS(String plugin, TaskInput taskInput) {
        String command = String.valueOf(taskInput.getOpenSearchBin().resolve("opensearch-plugin")) + " install " + plugin;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (OS.WINDOWS == OS.current()) {
            processBuilder.command("cmd.exe", "/c", command);
        } else {
            processBuilder.command("sh", "-c", command);
        }
        return processBuilder;
    }

    static {
        try (InputStream stream = InstallPluginsTask.class.getResourceAsStream("/plugins.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            HashSet<String> plugins = new HashSet<String>();
            String line = reader.readLine();
            while (line != null) {
                plugins.add(line.trim());
                line = reader.readLine();
            }
            OFFICIAL_PLUGINS = Collections.unmodifiableSet(plugins);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum OS {
        WINDOWS,
        MAC,
        LINUX;


        public static OS current() {
            String os = System.getProperty("os.name", "");
            if (os.startsWith("Windows")) {
                return WINDOWS;
            }
            if (os.startsWith("Linux") || os.startsWith("LINUX")) {
                return LINUX;
            }
            if (os.startsWith("Mac")) {
                return MAC;
            }
            throw new IllegalStateException("Can't determine OS from: " + os);
        }
    }
}

