/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.Map;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;

public final class CopyProcessor
extends AbstractProcessor {
    public static final String TYPE = "copy";
    private final TemplateScript.Factory sourceField;
    private final TemplateScript.Factory targetField;
    private final boolean ignoreMissing;
    private final boolean removeSource;
    private final boolean overrideTarget;

    CopyProcessor(String tag, String description, TemplateScript.Factory sourceField, TemplateScript.Factory targetField) {
        this(tag, description, sourceField, targetField, false, false, false);
    }

    CopyProcessor(String tag, String description, TemplateScript.Factory sourceField, TemplateScript.Factory targetField, boolean ignoreMissing, boolean removeSource, boolean overrideTarget) {
        super(tag, description);
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.removeSource = removeSource;
        this.overrideTarget = overrideTarget;
    }

    public TemplateScript.Factory getSourceField() {
        return this.sourceField;
    }

    public TemplateScript.Factory getTargetField() {
        return this.targetField;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public boolean isRemoveSource() {
        return this.removeSource;
    }

    public boolean isOverrideTarget() {
        return this.overrideTarget;
    }

    public IngestDocument execute(IngestDocument document) {
        String source = document.renderTemplate(this.sourceField);
        boolean sourceFieldPathIsNullOrEmpty = Strings.isNullOrEmpty((String)source);
        if (sourceFieldPathIsNullOrEmpty || !document.hasField(source, true)) {
            if (this.ignoreMissing) {
                return document;
            }
            if (sourceFieldPathIsNullOrEmpty) {
                throw new IllegalArgumentException("source field path cannot be null nor empty");
            }
            throw new IllegalArgumentException("source field [" + source + "] doesn't exist");
        }
        String target = document.renderTemplate(this.targetField);
        if (Strings.isNullOrEmpty((String)target)) {
            throw new IllegalArgumentException("target field path cannot be null nor empty");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("source field path and target field path cannot be same");
        }
        if (!this.overrideTarget && document.hasField(target, true) && document.getFieldValue(target, Object.class) != null) {
            throw new IllegalArgumentException("target field [" + target + "] already exists");
        }
        Object sourceValue = document.getFieldValue(source, Object.class);
        document.setFieldValue(target, IngestDocument.deepCopy((Object)sourceValue));
        if (this.removeSource) {
            document.removeField(source);
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public CopyProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String sourceField = ConfigurationUtils.readStringProperty((String)CopyProcessor.TYPE, (String)processorTag, config, (String)"source_field");
            TemplateScript.Factory sourceFieldTemplate = ConfigurationUtils.compileTemplate((String)CopyProcessor.TYPE, (String)processorTag, (String)"source_field", (String)sourceField, (ScriptService)this.scriptService);
            String targetField = ConfigurationUtils.readStringProperty((String)CopyProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            TemplateScript.Factory targetFieldTemplate = ConfigurationUtils.compileTemplate((String)CopyProcessor.TYPE, (String)processorTag, (String)"target_field", (String)targetField, (ScriptService)this.scriptService);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)CopyProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean removeSource = ConfigurationUtils.readBooleanProperty((String)CopyProcessor.TYPE, (String)processorTag, config, (String)"remove_source", (boolean)false);
            boolean overrideTarget = ConfigurationUtils.readBooleanProperty((String)CopyProcessor.TYPE, (String)processorTag, config, (String)"override_target", (boolean)false);
            return new CopyProcessor(processorTag, description, sourceFieldTemplate, targetFieldTemplate, ignoreMissing, removeSource, overrideTarget);
        }
    }
}

