/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.index.remote.RemoteStoreEnums;

@PublicApi(since="2.14.0")
@ExperimentalApi
public class RemoteStorePathStrategy {
    private final RemoteStoreEnums.PathType type;
    @Nullable
    private final RemoteStoreEnums.PathHashAlgorithm hashAlgorithm;

    public RemoteStorePathStrategy(RemoteStoreEnums.PathType type) {
        this(type, null);
    }

    public RemoteStorePathStrategy(RemoteStoreEnums.PathType type, RemoteStoreEnums.PathHashAlgorithm hashAlgorithm) {
        Objects.requireNonNull(type, "pathType can not be null");
        if (!RemoteStorePathStrategy.isCompatible(type, hashAlgorithm)) {
            throw new IllegalArgumentException(new ParameterizedMessage("pathType={} pathHashAlgorithm={} are incompatible", (Object)type, (Object)hashAlgorithm).getFormattedMessage());
        }
        this.type = type;
        this.hashAlgorithm = hashAlgorithm;
    }

    public static boolean isCompatible(RemoteStoreEnums.PathType type, RemoteStoreEnums.PathHashAlgorithm hashAlgorithm) {
        return !type.requiresHashAlgorithm() && Objects.isNull((Object)hashAlgorithm) || type.requiresHashAlgorithm() && Objects.nonNull((Object)hashAlgorithm);
    }

    public RemoteStoreEnums.PathType getType() {
        return this.type;
    }

    public RemoteStoreEnums.PathHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String toString() {
        return "RemoteStorePathStrategy{type=" + String.valueOf((Object)this.type) + ", hashAlgorithm=" + String.valueOf((Object)this.hashAlgorithm) + "}";
    }

    public BlobPath generatePath(BasePathInput pathInput) {
        return this.type.path(pathInput, this.hashAlgorithm);
    }

    public BlobPath generatePath(PathInput pathInput) {
        return this.type.path(pathInput, this.hashAlgorithm);
    }

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static class BasePathInput {
        private final BlobPath basePath;
        private final String indexUUID;

        public BasePathInput(BlobPath basePath, String indexUUID) {
            this.basePath = basePath;
            this.indexUUID = indexUUID;
        }

        public BasePathInput(Builder<?> builder) {
            this.basePath = Objects.requireNonNull(builder.basePath);
            this.indexUUID = Objects.requireNonNull(builder.indexUUID);
        }

        BlobPath basePath() {
            return this.basePath;
        }

        String indexUUID() {
            return this.indexUUID;
        }

        BlobPath fixedSubPath() {
            return BlobPath.cleanPath().add(this.indexUUID);
        }

        public static Builder<?> builder() {
            return new Builder();
        }

        public void assertIsValid() {
        }

        @PublicApi(since="2.14.0")
        @ExperimentalApi
        public static class Builder<T extends Builder<T>> {
            private BlobPath basePath;
            private String indexUUID;

            public T basePath(BlobPath basePath) {
                this.basePath = basePath;
                return this.self();
            }

            public Builder indexUUID(String indexUUID) {
                this.indexUUID = indexUUID;
                return this.self();
            }

            protected T self() {
                return (T)this;
            }

            public BasePathInput build() {
                return new BasePathInput(this);
            }
        }
    }

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static class PathInput
    extends BasePathInput {
        private final String shardId;
        private final RemoteStoreEnums.DataCategory dataCategory;
        private final RemoteStoreEnums.DataType dataType;

        public PathInput(BlobPath basePath, String indexUUID, String shardId, RemoteStoreEnums.DataCategory dataCategory, RemoteStoreEnums.DataType dataType) {
            super(basePath, indexUUID);
            this.shardId = shardId;
            this.dataCategory = dataCategory;
            this.dataType = dataType;
        }

        public PathInput(Builder builder) {
            super(builder);
            this.shardId = Objects.requireNonNull(builder.shardId);
            this.dataCategory = Objects.requireNonNull(builder.dataCategory);
            this.dataType = Objects.requireNonNull(builder.dataType);
            assert (this.dataCategory.isSupportedDataType(this.dataType)) : "category:" + String.valueOf((Object)this.dataCategory) + " type:" + String.valueOf((Object)this.dataType) + " are not supported together";
        }

        String shardId() {
            return this.shardId;
        }

        RemoteStoreEnums.DataCategory dataCategory() {
            return this.dataCategory;
        }

        RemoteStoreEnums.DataType dataType() {
            return this.dataType;
        }

        @Override
        BlobPath fixedSubPath() {
            return super.fixedSubPath().add(this.shardId).add(this.dataCategory.getName()).add(this.dataType.getName());
        }

        public static Builder builder() {
            return new Builder();
        }

        @PublicApi(since="2.14.0")
        @ExperimentalApi
        public static class Builder
        extends BasePathInput.Builder<Builder> {
            private String shardId;
            private RemoteStoreEnums.DataCategory dataCategory;
            private RemoteStoreEnums.DataType dataType;

            @Override
            public Builder basePath(BlobPath basePath) {
                this.basePath = basePath;
                return this;
            }

            @Override
            public Builder indexUUID(String indexUUID) {
                this.indexUUID = indexUUID;
                return this;
            }

            public Builder shardId(String shardId) {
                this.shardId = shardId;
                return this;
            }

            public Builder dataCategory(RemoteStoreEnums.DataCategory dataCategory) {
                this.dataCategory = dataCategory;
                return this;
            }

            public Builder dataType(RemoteStoreEnums.DataType dataType) {
                this.dataType = dataType;
                return this;
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            public PathInput build() {
                return new PathInput(this);
            }
        }
    }
}

