/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.Objects;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.regex.Regex;

@PublicApi(since="2.16.0")
public class SystemIndexDescriptor {
    private final String indexPattern;
    private final String description;
    private final CharacterRunAutomaton indexPatternAutomaton;

    public SystemIndexDescriptor(String indexPattern, String description) {
        Objects.requireNonNull(indexPattern, "system index pattern must not be null");
        if (indexPattern.length() < 2) {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must at least 2 characters in length");
        }
        if (indexPattern.charAt(0) != '.') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must start with the character [.]");
        }
        if (indexPattern.charAt(1) == '*') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must not start with the character sequence [.*] to prevent conflicts");
        }
        this.indexPattern = indexPattern;
        this.indexPatternAutomaton = new CharacterRunAutomaton(Regex.simpleMatchToAutomaton(indexPattern));
        this.description = description;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public boolean matchesIndexPattern(String index) {
        return this.indexPatternAutomaton.run(index);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "SystemIndexDescriptor[pattern=[" + this.indexPattern + "], description=[" + this.description + "]]";
    }
}

