/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lucene.store.IndexOutputOutputStream;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class BaseBlobStoreFormat<T extends ToXContent> {
    private static final int BUFFER_SIZE = 4096;
    private final String blobNameFormat;
    private final boolean skipHeaderFooter;

    public BaseBlobStoreFormat(String blobNameFormat, boolean skipHeaderFooter) {
        this.blobNameFormat = blobNameFormat;
        this.skipHeaderFooter = skipHeaderFooter;
    }

    protected String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    protected void write(T obj, BlobContainer blobContainer, String name, Compressor compressor, ToXContent.Params params, XContentType xContentType, String codec, Integer version) throws IOException {
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, compressor, params, xContentType, codec, version);
        blobContainer.writeBlob(blobName, (InputStream)bytes.streamInput(), bytes.length(), false);
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor, ToXContent.Params params, XContentType xContentType, String codec, Integer version) throws IOException {
        assert (this.skipHeaderFooter || Objects.nonNull(codec) && Objects.nonNull(version));
        try (BytesStreamOutput outputStream = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, (OutputStream)((Object)outputStream), 4096);){
                if (!this.skipHeaderFooter) {
                    CodecUtil.writeHeader((DataOutput)indexOutput, (String)codec, (int)version);
                }
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream((IndexOutput)indexOutput){

                    @Override
                    public void close() {
                    }
                };
                     XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)xContentType, (OutputStream)compressor.threadLocalOutputStream((OutputStream)indexOutputOutputStream));){
                    builder.startObject();
                    obj.toXContent(builder, params);
                    builder.endObject();
                }
                if (!this.skipHeaderFooter) {
                    CodecUtil.writeFooter((IndexOutput)indexOutput);
                }
            }
            BytesReference bytesReference = outputStream.bytes();
            return bytesReference;
        }
    }

    protected String getBlobNameFormat() {
        return this.blobNameFormat;
    }
}

