/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform.transformations;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DoubleProvenance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationProvenance;
import org.tribuo.transform.Transformer;

public final class LinearScalingTransformation
implements Transformation {
    private static final String TARGET_MIN = "targetMin";
    private static final String TARGET_MAX = "targetMax";
    @Config(mandatory=true, description="Minimum value after transformation.")
    private double targetMin = 0.0;
    @Config(mandatory=true, description="Maximum value after transformation.")
    private double targetMax = 1.0;
    private TransformationProvenance provenance;

    public LinearScalingTransformation() {
    }

    public LinearScalingTransformation(double targetMin, double targetMax) {
        this.targetMin = targetMin;
        this.targetMax = targetMax;
        this.postConfig();
    }

    public void postConfig() {
        if (this.targetMax < this.targetMin) {
            throw new IllegalArgumentException("Range must be positive, min = " + this.targetMin + ", max = " + this.targetMax);
        }
    }

    @Override
    public TransformStatistics createStats() {
        return new LinearScalingStatistics(this.targetMin, this.targetMax);
    }

    public synchronized TransformationProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = new LinearScalingTransformationProvenance(this);
        }
        return this.provenance;
    }

    public String toString() {
        return "LinearScalingTransformation(targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
    }

    private static class LinearScalingTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;
        private final double observedMin;
        private final double observedMax;
        private final double targetMin;
        private final double targetMax;
        private final double scalingFactor;
        private final boolean constant;

        public LinearScalingTransformer(double observedMin, double observedMax, double targetMin, double targetMax) {
            this.observedMin = observedMin;
            this.observedMax = observedMax;
            this.targetMin = targetMin;
            this.targetMax = targetMax;
            double observedRange = observedMax - observedMin;
            this.constant = observedRange == 0.0;
            double targetRange = targetMax - targetMin;
            this.scalingFactor = targetRange / observedRange;
        }

        @Override
        public double transform(double input) {
            if (this.constant) {
                return (this.targetMax - this.targetMin) / 2.0;
            }
            if (input < this.observedMin) {
                return this.targetMin;
            }
            if (input > this.observedMax) {
                return this.targetMax;
            }
            return (input - this.observedMin) * this.scalingFactor + this.targetMin;
        }

        public String toString() {
            return "LinearScalingTransformer(observedMin=" + this.observedMin + ",observedMax=" + this.observedMax + ",targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
        }
    }

    private static class LinearScalingStatistics
    implements TransformStatistics {
        private final double targetMin;
        private final double targetMax;
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;

        public LinearScalingStatistics(double targetMin, double targetMax) {
            this.targetMin = targetMin;
            this.targetMax = targetMax;
        }

        @Override
        public void observeValue(double value) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }

        @Override
        @Deprecated
        public void observeSparse() {
            this.observeValue(0.0);
        }

        @Override
        public void observeSparse(int count) {
            this.observeValue(0.0);
        }

        @Override
        public Transformer generateTransformer() {
            return new LinearScalingTransformer(this.min, this.max, this.targetMin, this.targetMax);
        }

        public String toString() {
            return "LinearScalingStatistics(min=" + this.min + ",max=" + this.max + ",targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
        }
    }

    public static final class LinearScalingTransformationProvenance
    implements TransformationProvenance {
        private static final long serialVersionUID = 1L;
        private final DoubleProvenance targetMin;
        private final DoubleProvenance targetMax;

        LinearScalingTransformationProvenance(LinearScalingTransformation host) {
            this.targetMin = new DoubleProvenance(LinearScalingTransformation.TARGET_MIN, host.targetMin);
            this.targetMax = new DoubleProvenance(LinearScalingTransformation.TARGET_MAX, host.targetMax);
        }

        public LinearScalingTransformationProvenance(Map<String, Provenance> map) {
            this.targetMin = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)LinearScalingTransformation.TARGET_MIN, DoubleProvenance.class, (String)LinearScalingTransformationProvenance.class.getSimpleName());
            this.targetMax = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)LinearScalingTransformation.TARGET_MAX, DoubleProvenance.class, (String)LinearScalingTransformationProvenance.class.getSimpleName());
        }

        public String getClassName() {
            return LinearScalingTransformation.class.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinearScalingTransformationProvenance)) {
                return false;
            }
            LinearScalingTransformationProvenance pairs = (LinearScalingTransformationProvenance)o;
            return this.targetMin.equals((Object)pairs.targetMin) && this.targetMax.equals((Object)pairs.targetMax);
        }

        public int hashCode() {
            return Objects.hash(this.targetMin, this.targetMax);
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, DoubleProvenance> map = new HashMap<String, DoubleProvenance>();
            map.put(LinearScalingTransformation.TARGET_MIN, this.targetMin);
            map.put(LinearScalingTransformation.TARGET_MAX, this.targetMax);
            return Collections.unmodifiableMap(map);
        }
    }
}

