/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.OSMetricsGeneratorFactory;
import org.opensearch.performanceanalyzer.commons.collectors.NetInterfaceSummary;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.metrics_generator.IPMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.metrics_generator.OSMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class NetworkInterfaceCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final int sTimeInterval = MetricsConfiguration.CONFIG_MAP.get(NetworkInterfaceCollector.class).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(NetworkInterfaceCollector.class);

    public NetworkInterfaceCollector() {
        super(sTimeInterval, "NetworkInterfaceCollector", StatMetrics.NETWORK_INTERFACE_COLLECTOR_EXECUTION_TIME, StatExceptionCode.NETWORK_COLLECTION_ERROR);
    }

    @Override
    public void collectMetrics(long startTime) {
        OSMetricsGenerator generator = OSMetricsGeneratorFactory.getInstance();
        if (generator == null) {
            return;
        }
        IPMetricsGenerator IPMetricsGenerator2 = generator.getIPMetricsGenerator();
        IPMetricsGenerator2.addSample();
        this.saveMetricValues(this.getMetrics(IPMetricsGenerator2) + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor, startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "ip_metrics");
    }

    private String getMetrics(IPMetricsGenerator IPMetricsGenerator2) {
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        try {
            NetInterfaceSummary inNetwork = new NetInterfaceSummary(NetInterfaceSummary.Direction.in, IPMetricsGenerator2.getInPacketRate4(), IPMetricsGenerator2.getInDropRate4(), IPMetricsGenerator2.getInPacketRate6(), IPMetricsGenerator2.getInDropRate6(), IPMetricsGenerator2.getInBps());
            NetInterfaceSummary outNetwork = new NetInterfaceSummary(NetInterfaceSummary.Direction.out, IPMetricsGenerator2.getOutPacketRate4(), IPMetricsGenerator2.getOutDropRate4(), IPMetricsGenerator2.getOutPacketRate6(), IPMetricsGenerator2.getOutDropRate6(), IPMetricsGenerator2.getOutBps());
            this.value.append(inNetwork.serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            this.value.append(outNetwork.serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        catch (Exception e) {
            LOG.debug("Exception in NetworkInterfaceCollector: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.NETWORK_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.NETWORK_COLLECTION_ERROR);
        }
        return this.value.toString();
    }
}

