/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.HashingFunction;
import com.password4j.Utils;
import java.util.Arrays;
import java.util.Objects;

public class Hash {
    private byte[] result;
    private byte[] bytes;
    private byte[] salt;
    private CharSequence pepper;
    private HashingFunction hashingFunction;

    private Hash() {
    }

    @Deprecated
    public Hash(HashingFunction hashingFunction, String result, byte[] bytes, String salt) {
        this(hashingFunction, Utils.fromCharSequenceToBytes(result), bytes, Utils.fromCharSequenceToBytes(salt));
    }

    public Hash(HashingFunction hashingFunction, String result, byte[] bytes, byte[] salt) {
        this(hashingFunction, Utils.fromCharSequenceToBytes(result), bytes, salt);
    }

    public Hash(HashingFunction hashingFunction, byte[] result, byte[] bytes, byte[] salt) {
        this.hashingFunction = hashingFunction;
        this.salt = salt;
        this.result = result;
        this.bytes = bytes;
    }

    private static boolean areEquals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 != null && cs2 != null) {
            return cs1.equals(cs2);
        }
        return false;
    }

    public String getResult() {
        return Utils.fromBytesToString(this.result);
    }

    public byte[] getResultAsBytes() {
        return this.result;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public HashingFunction getHashingFunction() {
        return this.hashingFunction;
    }

    public String getSalt() {
        return Utils.fromBytesToString(this.salt);
    }

    public byte[] getSaltBytes() {
        return this.salt;
    }

    public CharSequence getPepper() {
        return this.pepper;
    }

    void setPepper(CharSequence pepper) {
        this.pepper = pepper;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hashingFunction != null) {
            sb.append(this.hashingFunction.getClass().getSimpleName());
        }
        sb.append("[salt=").append(this.getSalt()).append(", pepper=").append(this.getPepper()).append(", hash=").append(this.getResult()).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Hash otherHash = (Hash)obj;
        return this.hasSameValues(otherHash);
    }

    private boolean hasSameValues(Hash otherHash) {
        return Arrays.equals(this.result, otherHash.result) && Arrays.equals(this.bytes, otherHash.bytes) && Arrays.equals(this.salt, otherHash.salt) && Hash.areEquals(this.pepper, otherHash.pepper) && this.hashingFunction.equals(otherHash.hashingFunction);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.result), Arrays.hashCode(this.salt), this.pepper, this.hashingFunction);
    }
}

