/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateResponse;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractApiAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbstractApiAction.class);
    private static final Set<String> supportedPatchOperations = Set.of("add", "replace", "remove");
    private static final String supportedPatchOperationsAsString = String.join((CharSequence)",", supportedPatchOperations);
    protected final ClusterService clusterService;
    protected final ThreadPool threadPool;
    private Map<RestRequest.Method, RequestHandler> requestHandlers;
    protected final RequestHandler.RequestHandlersBuilder requestHandlersBuilder;
    protected final EndpointValidator endpointValidator;
    protected final Endpoint endpoint;
    protected final SecurityApiDependencies securityApiDependencies;

    protected AbstractApiAction(Endpoint endpoint, ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        this.endpoint = endpoint;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.securityApiDependencies = securityApiDependencies;
        this.requestHandlersBuilder = new RequestHandler.RequestHandlersBuilder();
        this.requestHandlersBuilder.configureRequestHandlers(this::buildDefaultRequestHandlers);
        this.endpointValidator = this.createEndpointValidator();
    }

    private void buildDefaultRequestHandlers(RequestHandler.RequestHandlersBuilder builder) {
        builder.withAccessHandler(request -> this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint)).withSaveOrUpdateConfigurationHandler(this::saveOrUpdateConfiguration).add(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler).add(RestRequest.Method.PATCH, RequestHandler.methodNotImplementedHandler).onGetRequest((CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processGetRequest)).onChangeRequest(RestRequest.Method.DELETE, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processDeleteRequest)).onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPutRequest));
    }

    protected final ValidationResult<SecurityConfiguration> processDeleteRequest(RestRequest request) throws IOException {
        return this.endpointValidator.withRequiredEntityName(this.nameParam(request)).map(entityName -> this.loadConfiguration((String)entityName, false)).map(this.endpointValidator::onConfigDelete).map(this::removeEntityFromConfig);
    }

    protected final ValidationResult<SecurityConfiguration> removeEntityFromConfig(SecurityConfiguration securityConfiguration) {
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        configuration.remove(securityConfiguration.entityName());
        return ValidationResult.success(securityConfiguration);
    }

    protected final ValidationResult<SecurityConfiguration> processGetRequest(RestRequest request) throws IOException {
        return this.loadConfiguration(this.getConfigType(), true, true).map(configuration -> ValidationResult.success(SecurityConfiguration.of(this.nameParam(request), configuration))).map(this.endpointValidator::onConfigLoad).map(securityConfiguration -> securityConfiguration.maybeEntityName().map(entityName -> {
            securityConfiguration.configuration().removeOthers((String)entityName);
            return ValidationResult.success(securityConfiguration);
        }).orElse(ValidationResult.success(securityConfiguration)));
    }

    protected final ValidationResult<SecurityConfiguration> processPatchRequest(RestRequest request) throws IOException {
        return this.loadConfiguration(this.nameParam(request), false).map(securityConfiguration -> this.withPatchRequestContent(request).map(patchContent -> securityConfiguration.maybeEntityName().map(entityName -> this.patchEntity(request, (JsonNode)patchContent, (SecurityConfiguration)securityConfiguration)).orElseGet(() -> this.patchEntities(request, (JsonNode)patchContent, (SecurityConfiguration)securityConfiguration))));
    }

    protected final ValidationResult<JsonNode> withPatchRequestContent(RestRequest request) {
        try {
            JsonNode parsedPatchRequestContent = Utils.toJsonNode(request.content().utf8ToString());
            if (!(parsedPatchRequestContent instanceof ArrayNode)) {
                return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Wrong request body"));
            }
            Set<String> operations = this.patchOperations(parsedPatchRequestContent);
            if (operations.isEmpty()) {
                return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Wrong request body"));
            }
            for (String patchOperation : operations) {
                if (supportedPatchOperations.contains(patchOperation)) continue;
                return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Unsupported patch operation: " + patchOperation + ". Supported are: " + supportedPatchOperationsAsString));
            }
            return ValidationResult.success(parsedPatchRequestContent);
        }
        catch (IOException e) {
            LOGGER.debug("Error while parsing JSON patch", (Throwable)e);
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Error in JSON patch: " + e.getMessage()));
        }
    }

    protected final ValidationResult<SecurityConfiguration> patchEntity(RestRequest request, JsonNode patchContent, SecurityConfiguration securityConfiguration) {
        String entityName = securityConfiguration.entityName();
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        return (ValidationResult)Utils.withIOException(() -> this.endpointValidator.isAllowedToChangeImmutableEntity(securityConfiguration).map(this.endpointValidator::entityExists).map(ignore -> {
            ObjectNode configurationAsJson = (ObjectNode)Utils.convertJsonToJackson(configuration, true);
            ObjectNode entityAsJson = (ObjectNode)configurationAsJson.get(entityName);
            return this.withJsonPatchException((CheckedSupplier<ValidationResult<SecurityConfiguration>, IOException>)((CheckedSupplier)() -> this.endpointValidator.createRequestContentValidator(entityName).validate(request, JsonPatch.apply((JsonNode)patchContent, (JsonNode)entityAsJson), configurationAsJson.get(entityName)).map(patchedEntity -> this.endpointValidator.onConfigChange(SecurityConfiguration.of(patchedEntity, entityName, configuration)).map(sc -> ValidationResult.success(patchedEntity))).map(patchedEntity -> {
                JsonNode updatedConfigurationAsJson = configurationAsJson.deepCopy().set(entityName, patchedEntity);
                return ValidationResult.success(SecurityConfiguration.of(entityName, SecurityDynamicConfiguration.fromNode(updatedConfigurationAsJson, configuration.getCType(), configuration.getVersion(), configuration.getSeqNo(), configuration.getPrimaryTerm())));
            })));
        }));
    }

    protected ValidationResult<SecurityConfiguration> patchEntities(RestRequest request, JsonNode patchContent, SecurityConfiguration securityConfiguration) {
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        ObjectNode configurationAsJson = (ObjectNode)Utils.convertJsonToJackson(configuration, true);
        return (ValidationResult)Utils.withIOException(() -> this.withJsonPatchException((CheckedSupplier<ValidationResult<SecurityConfiguration>, IOException>)((CheckedSupplier)() -> {
            JsonNode patchedConfigurationAsJson = JsonPatch.apply((JsonNode)patchContent, (JsonNode)configurationAsJson);
            JsonNode patch = JsonDiff.asJson((JsonNode)configurationAsJson, (JsonNode)patchedConfigurationAsJson);
            if (patch.isEmpty()) {
                return ValidationResult.error(RestStatus.OK, Responses.payload(RestStatus.OK, "No updates required"));
            }
            for (String entityName : this.patchEntityNames(patchContent)) {
                ValidationResult<JsonNode> requestCheck;
                ValidationResult<SecurityConfiguration> checkEntityCanBeProcess;
                JsonNode beforePatchEntity = configurationAsJson.get(entityName);
                JsonNode patchedEntity = patchedConfigurationAsJson.get(entityName);
                if (beforePatchEntity != null && !Objects.equals(beforePatchEntity, patchedEntity) && !(checkEntityCanBeProcess = this.endpointValidator.isAllowedToChangeImmutableEntity(SecurityConfiguration.of(entityName, configuration))).isValid()) {
                    return checkEntityCanBeProcess;
                }
                if (patchedEntity == null) continue;
                if (!(beforePatchEntity != null && Objects.equals(beforePatchEntity, patchedEntity) || (requestCheck = this.endpointValidator.createRequestContentValidator(entityName).validate(request, patchedEntity)).isValid())) {
                    return ValidationResult.error(requestCheck.status(), requestCheck.errorMessage());
                }
                ValidationResult<SecurityConfiguration> additionalValidatorCheck = this.endpointValidator.onConfigChange(SecurityConfiguration.of(patchedEntity, entityName, configuration));
                if (additionalValidatorCheck.isValid()) continue;
                return additionalValidatorCheck;
            }
            return ValidationResult.success(SecurityConfiguration.of(null, SecurityDynamicConfiguration.fromNode(patchedConfigurationAsJson, configuration.getCType(), configuration.getVersion(), configuration.getSeqNo(), configuration.getPrimaryTerm())));
        })));
    }

    private ValidationResult<SecurityConfiguration> withJsonPatchException(CheckedSupplier<ValidationResult<SecurityConfiguration>, IOException> action) throws IOException {
        try {
            return (ValidationResult)action.get();
        }
        catch (JsonPatchApplicationException e) {
            LOGGER.debug("Error while applying JSON patch", (Throwable)e);
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(e.getMessage()));
        }
    }

    protected final Set<String> patchOperations(JsonNode patchRequestContent) {
        ImmutableSet.Builder operations = ImmutableSet.builder();
        for (JsonNode node : patchRequestContent) {
            if (!node.has("op")) continue;
            operations.add((Object)node.get("op").asText());
        }
        return operations.build();
    }

    protected final Set<String> patchEntityNames(JsonNode patchRequestContent) {
        ImmutableSet.Builder patchedResourceNames = ImmutableSet.builder();
        for (JsonNode node : patchRequestContent) {
            if (!node.has("path")) continue;
            JsonPointer s = JsonPointer.compile((String)node.get("path").asText());
            patchedResourceNames.add((Object)s.getMatchingProperty());
        }
        return patchedResourceNames.build();
    }

    protected final ValidationResult<SecurityConfiguration> processPutRequest(RestRequest request) throws IOException {
        return this.processPutRequest(this.nameParam(request), request);
    }

    protected final ValidationResult<SecurityConfiguration> processPutRequest(String entityName, RestRequest request) throws IOException {
        return this.endpointValidator.withRequiredEntityName(entityName).map(ignore -> this.loadConfigurationWithRequestContent(entityName, request)).map(this.endpointValidator::onConfigChange).map(this::addEntityToConfig);
    }

    protected final ValidationResult<SecurityConfiguration> addEntityToConfig(SecurityConfiguration securityConfiguration) throws IOException {
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        Object entityObjectConfig = Utils.toConfigObject(securityConfiguration.requestContent(), configuration.getImplementingClass());
        configuration.putCObject(securityConfiguration.entityName(), entityObjectConfig);
        return ValidationResult.success(securityConfiguration);
    }

    final void saveOrUpdateConfiguration(Client client, SecurityDynamicConfiguration<?> configuration, OnSucessActionListener<IndexResponse> onSucessActionListener) {
        AbstractApiAction.saveAndUpdateConfigsAsync(this.securityApiDependencies, client, this.getConfigType(), configuration, onSucessActionListener);
    }

    protected final String nameParam(RestRequest request) {
        String name = request.param("name");
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        return name;
    }

    protected final ValidationResult<SecurityConfiguration> loadConfigurationWithRequestContent(String entityName, RestRequest request) throws IOException {
        return this.endpointValidator.createRequestContentValidator(new Object[0]).validate(request).map(content -> this.loadConfiguration(this.getConfigType(), false, false).map(configuration -> ValidationResult.success(SecurityConfiguration.of(content, entityName, configuration))));
    }

    protected final ValidationResult<SecurityConfiguration> loadConfiguration(String entityName, boolean logComplianceEvent) throws IOException {
        return this.loadConfiguration(this.getConfigType(), false, logComplianceEvent).map(configuration -> ValidationResult.success(SecurityConfiguration.of(entityName, configuration)));
    }

    protected ValidationResult<SecurityDynamicConfiguration<?>> loadConfiguration(CType cType, boolean omitSensitiveData, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> configuration = omitSensitiveData ? this.loadAndRedact(cType, logComplianceEvent) : this.load(cType, logComplianceEvent);
        if (configuration.getSeqNo() < 0L) {
            return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Security index need to be updated to support '" + this.getConfigType().toLCString() + "'. Use SecurityAdmin to populate."));
        }
        if (omitSensitiveData) {
            if (!this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint)) {
                configuration.removeHidden();
            }
            configuration.clearHashes();
            configuration.set_meta(null);
        }
        return ValidationResult.success(configuration);
    }

    protected final ValidationResult<Pair<User, TransportAddress>> withUserAndRemoteAddress() {
        Pair<User, TransportAddress> userAndRemoteAddress = Utils.userAndRemoteAddressFrom(this.threadPool.getThreadContext());
        if (userAndRemoteAddress.getLeft() == null) {
            return ValidationResult.error(RestStatus.UNAUTHORIZED, Responses.payload(RestStatus.UNAUTHORIZED, "Unauthorized"));
        }
        return ValidationResult.success(userAndRemoteAddress);
    }

    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return AbstractApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return AbstractApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigDelete(SecurityConfiguration securityConfiguration) throws IOException {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Access denied"));
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigLoad(SecurityConfiguration securityConfiguration) throws IOException {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Access denied"));
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Access denied"));
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                return RequestContentValidator.NOOP_VALIDATOR;
            }
        };
    }

    protected abstract CType getConfigType();

    protected final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.securityApiDependencies.configurationRepository().getConfigurationsFromIndex(List.of(config), logComplianceEvent).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    protected final SecurityDynamicConfiguration<?> loadAndRedact(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.securityApiDependencies.configurationRepository().getConfigurationsFromIndex(List.of(config), logComplianceEvent).get((Object)config).deepCloneWithRedaction();
        return DynamicConfigFactory.addStatics(loaded);
    }

    protected boolean ensureIndexExists() {
        return this.clusterService.state().metadata().hasConcreteIndex(this.securityApiDependencies.securityIndexName());
    }

    public static ActionFuture<IndexResponse> saveAndUpdateConfigs(SecurityApiDependencies dependencies, Client client, CType cType, SecurityDynamicConfiguration<?> configuration) {
        IndexRequest request = AbstractApiAction.createIndexRequestForConfig(dependencies, cType, configuration);
        return client.index(request);
    }

    public static void saveAndUpdateConfigsAsync(SecurityApiDependencies dependencies, Client client, CType cType, SecurityDynamicConfiguration<?> configuration, ActionListener<IndexResponse> actionListener) {
        IndexRequest ir = AbstractApiAction.createIndexRequestForConfig(dependencies, cType, configuration);
        client.index(ir, new ConfigUpdatingActionListener<IndexResponse>(new String[]{cType.toLCString()}, client, actionListener));
    }

    private static IndexRequest createIndexRequestForConfig(SecurityApiDependencies dependencies, CType cType, SecurityDynamicConfiguration<?> configuration) {
        BytesReference content;
        configuration.removeStatic();
        try {
            content = XContentHelper.toXContent(configuration, (MediaType)XContentType.JSON, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)false);
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
        return ((IndexRequest)new IndexRequest(dependencies.securityIndexName()).id(cType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setIfSeqNo(configuration.getSeqNo()).setIfPrimaryTerm(configuration.getPrimaryTerm()).source(new Object[]{cType.toLCString(), content});
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String userName;
        this.consumeParameters(request);
        if (!this.ensureIndexExists()) {
            return channel -> Responses.internalServerError(channel, RequestContentValidator.ValidationError.SECURITY_NOT_INITIALIZED.message());
        }
        String authError = this.securityApiDependencies.restApiPrivilegesEvaluator().checkAccessPermissions(request, this.endpoint);
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        String string = userName = user == null ? null : user.getName();
        if (authError != null) {
            LOGGER.error("No permission to access REST API: " + authError);
            this.securityApiDependencies.auditLog().logMissingPrivileges(authError, userName, SecurityRequestFactory.from(request));
            request.params().clear();
            return channel -> Responses.forbidden(channel, "No permission to access REST API: " + authError);
        }
        this.securityApiDependencies.auditLog().logGrantedPrivileges(userName, SecurityRequestFactory.from(request));
        Pair<User, TransportAddress> originalUserAndRemoteAddress = Utils.userAndRemoteAddressFrom(this.threadPool.getThreadContext());
        Object originalOrigin = this.threadPool.getThreadContext().getTransient("_opendistro_security_origin");
        return channel -> this.threadPool.generic().submit(() -> {
            try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
                this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
                this.threadPool.getThreadContext().putTransient("_opendistro_security_user", originalUserAndRemoteAddress.getLeft());
                this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", originalUserAndRemoteAddress.getRight());
                this.threadPool.getThreadContext().putTransient("_opendistro_security_origin", originalOrigin);
                this.requestHandlers = Optional.ofNullable(this.requestHandlers).orElseGet(this.requestHandlersBuilder::build);
                RequestHandler requestHandler = this.requestHandlers.getOrDefault(request.method(), RequestHandler.methodNotImplementedHandler);
                requestHandler.handle((RestChannel)channel, request, (Client)client);
            }
            catch (Exception e) {
                LOGGER.error("Error processing request {}", (Object)request, (Object)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (IOException ioe) {
                    throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
                }
            }
        });
    }

    protected void consumeParameters(RestRequest request) {
        request.param("name");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected static class ConfigUpdatingActionListener<Response>
    implements ActionListener<Response> {
        private final String[] cTypes;
        private final Client client;
        private final ActionListener<Response> delegate;

        public ConfigUpdatingActionListener(String[] cTypes, Client client, ActionListener<Response> delegate) {
            this.cTypes = Objects.requireNonNull(cTypes, "cTypes must not be null");
            this.client = Objects.requireNonNull(client, "client must not be null");
            this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        }

        public void onResponse(final Response response) {
            ConfigUpdateRequest cur = new ConfigUpdateRequest(this.cTypes);
            this.client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)cur, (ActionListener)new ActionListener<ConfigUpdateResponse>(){

                public void onResponse(ConfigUpdateResponse ur) {
                    if (ur.hasFailures()) {
                        delegate.onFailure((Exception)ur.failures().get(0));
                        return;
                    }
                    delegate.onResponse(response);
                }

                public void onFailure(Exception e) {
                    delegate.onFailure(e);
                }
            });
        }

        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }

    static abstract class OnSucessActionListener<Response>
    implements ActionListener<Response> {
        private final RestChannel channel;

        public OnSucessActionListener(RestChannel channel) {
            this.channel = channel;
        }

        public final void onFailure(Exception e) {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                Responses.conflict(this.channel, e.getMessage());
            } else {
                Responses.internalServerError(this.channel, "Error " + e.getMessage());
            }
        }
    }
}

