/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import org.opensearch.action.ActionRequest;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;

public class PrivilegesEvaluationContext {
    private final User user;
    private final String action;
    private final ActionRequest request;
    private IndexResolverReplacer.Resolved resolvedRequest;
    private final Task task;
    private ImmutableSet<String> mappedRoles;
    private final IndexResolverReplacer indexResolverReplacer;

    public PrivilegesEvaluationContext(User user, ImmutableSet<String> mappedRoles, String action, ActionRequest request, Task task, IndexResolverReplacer indexResolverReplacer) {
        this.user = user;
        this.mappedRoles = mappedRoles;
        this.action = action;
        this.request = request;
        this.task = task;
        this.indexResolverReplacer = indexResolverReplacer;
    }

    public User getUser() {
        return this.user;
    }

    public String getAction() {
        return this.action;
    }

    public ActionRequest getRequest() {
        return this.request;
    }

    public IndexResolverReplacer.Resolved getResolvedRequest() {
        IndexResolverReplacer.Resolved result = this.resolvedRequest;
        if (result == null) {
            this.resolvedRequest = result = this.indexResolverReplacer.resolveRequest(this.request);
        }
        return result;
    }

    public Task getTask() {
        return this.task;
    }

    public ImmutableSet<String> getMappedRoles() {
        return this.mappedRoles;
    }

    void setMappedRoles(ImmutableSet<String> mappedRoles) {
        this.mappedRoles = mappedRoles;
    }
}

