/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteRequest;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteAgentTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteAgentTransportAction.class);
    Client client;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;

    @Inject
    public DeleteAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/agents/delete", transportService, actionFilters, MLAgentDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLAgentDeleteRequest mlAgentDeleteRequest = MLAgentDeleteRequest.fromActionRequest((ActionRequest)request);
        String agentId = mlAgentDeleteRequest.getAgentId();
        GetRequest getRequest = new GetRequest(".plugins-ml-agent").id(agentId);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                if (getResponse.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, getResponse.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                        if (mlAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                            actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this hidden agent", RestStatus.FORBIDDEN, new Object[0]));
                        } else {
                            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-agent", agentId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                                log.debug("Completed Delete Agent Request, agent id:{} deleted", (Object)agentId);
                                actionListener.onResponse(deleteResponse);
                            }, deleteException -> {
                                log.error("Failed to delete ML Agent " + agentId, (Throwable)deleteException);
                                actionListener.onFailure(deleteException);
                            }));
                        }
                    }
                    catch (Exception parseException) {
                        log.error("Failed to parse ml agent " + getResponse.getId(), (Throwable)parseException);
                        actionListener.onFailure(parseException);
                    }
                } else {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find agent with the provided agent id: " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, getException -> {
                log.error("Failed to get ml agent " + agentId, (Throwable)getException);
                actionListener.onFailure(getException);
            }));
        }
        catch (Exception e) {
            log.error("Failed to delete ml agent " + agentId, (Throwable)e);
            actionListener.onFailure(e);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

