/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportSearchAgentAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportSearchAgentAction.class);
    private final Client client;

    @Inject
    public TransportSearchAgentAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/opensearch/ml/agents/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        request.indices(new String[]{".plugins-ml-agent"});
        this.search(request, actionListener);
    }

    private void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search agent");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            if (request.source().query() != null) {
                queryBuilder.must(request.source().query());
            }
            BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
            shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)false));
            shouldQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden")));
            shouldQuery.minimumShouldMatch(1);
            queryBuilder.filter((QueryBuilder)shouldQuery);
            request.source().query((QueryBuilder)queryBuilder);
            this.client.search(request, wrappedListener);
        }
        catch (Exception e) {
            log.error("failed to search the agent index", (Throwable)e);
            actionListener.onFailure(e);
        }
    }
}

