/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.transport.task.MLTaskDeleteRequest;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteTaskTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteTaskTransportAction.class);
    Client client;
    NamedXContentRegistry xContentRegistry;

    @Inject
    public DeleteTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/ml/tasks/delete", transportService, actionFilters, MLTaskDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.fromActionRequest((ActionRequest)request);
        final String taskId = mlTaskDeleteRequest.getTaskId();
        GetRequest getRequest = new GetRequest(".plugins-ml-task").id(taskId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            final ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLTask mlTask = MLTask.parse((XContentParser)parser);
                        MLTaskState mlTaskState = mlTask.getState();
                        if (mlTaskState.equals((Object)MLTaskState.RUNNING)) {
                            actionListener.onFailure(new Exception("Task cannot be deleted in running state. Try after sometime"));
                        } else {
                            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-task", taskId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

                                public void onResponse(DeleteResponse deleteResponse) {
                                    log.debug("Completed Delete Task Request, task id:{} deleted", (Object)taskId);
                                    wrappedListener.onResponse((Object)deleteResponse);
                                }

                                public void onFailure(Exception e) {
                                    log.error("Failed to delete ML Task " + taskId, (Throwable)e);
                                    wrappedListener.onFailure(e);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ML task " + taskId, (Throwable)e);
                        wrappedListener.onFailure(e);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find task"));
                }
            }, e -> wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find task"))));
        }
        catch (Exception e2) {
            log.error("Failed to delete ml task " + taskId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

