/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.GetInteractionRequest;
import org.opensearch.ml.memory.action.conversation.GetInteractionResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetInteractionTransportAction
extends HandledTransportAction<GetInteractionRequest, GetInteractionResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetInteractionTransportAction.class);
    private final Client client;
    private final ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public GetInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/interaction/get", transportService, actionFilters, GetInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, GetInteractionRequest request, ActionListener<GetInteractionResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new OpenSearchException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String interactionId = request.getInteractionId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener al = ActionListener.wrap(interaction -> internalListener.onResponse((Object)new GetInteractionResponse((Interaction)interaction)), arg_0 -> ((ActionListener)internalListener).onFailure(arg_0));
            this.cmHandler.getInteraction(interactionId, (ActionListener<Interaction>)al);
        }
        catch (Exception e) {
            log.error("Failed to get message {}", (Object)interactionId, (Object)e);
            actionListener.onFailure(e);
        }
    }
}

