/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.logtype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.LogType;
import org.opensearch.securityanalytics.util.FileUtils;

public class BuiltinLogTypeLoader
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(BuiltinLogTypeLoader.class);
    private static final String BASE_PATH = "OSMapping/";
    private static final String LOG_TYPE_FILE_SUFFIX = "_logtype.json";
    private List<LogType> logTypes;
    private Map<String, LogType> logTypeMap;

    public List<LogType> getAllLogTypes() {
        this.ensureLogTypesLoaded();
        return this.logTypes;
    }

    public LogType getLogTypeByName(String logTypeName) {
        this.ensureLogTypesLoaded();
        return this.logTypeMap.get(logTypeName);
    }

    public boolean logTypeExists(String logTypeName) {
        this.ensureLogTypesLoaded();
        return this.logTypeMap.containsKey(logTypeName);
    }

    public void ensureLogTypesLoaded() {
        try {
            if (this.logTypes != null) {
                return;
            }
            this.logTypes = this.loadBuiltinLogTypes();
            this.logTypeMap = this.logTypes.stream().collect(Collectors.toMap(LogType::getName, Function.identity()));
        }
        catch (Exception e) {
            logger.error("Failed loading builtin log types from disk!", (Throwable)e);
        }
    }

    private List<LogType> loadBuiltinLogTypes() throws URISyntaxException, IOException {
        ArrayList<LogType> logTypes = new ArrayList<LogType>();
        String pathurl = Paths.get(BuiltinLogTypeLoader.class.getClassLoader().getResource(BASE_PATH).toURI()).toString();
        String url = Objects.requireNonNull(BuiltinLogTypeLoader.class.getClassLoader().getResource(BASE_PATH)).toURI().toString();
        Path dirPath = null;
        if (url.contains("!")) {
            String[] paths = url.split("!");
            dirPath = FileUtils.getFs().getPath(paths[1], new String[0]);
        } else {
            dirPath = Path.of(url, new String[0]);
        }
        Stream<Path> folder = Files.list(dirPath);
        List logTypePaths = folder.filter(e -> e.toString().endsWith(LOG_TYPE_FILE_SUFFIX)).collect(Collectors.toList());
        for (Path logTypePath : logTypePaths) {
            try {
                InputStream is = BuiltinLogTypeLoader.class.getResourceAsStream(logTypePath.toString());
                try {
                    String logTypeFilePayload = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
                    if (logTypeFilePayload == null) continue;
                    Map logTypeFileAsMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)logTypeFilePayload, (boolean)false);
                    logTypes.add(new LogType(logTypeFileAsMap));
                    logger.info("Loaded [{}] log type", (Object)logTypePath.getFileName());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e2) {
                throw new SettingsException("Failed to load builtin log types", (Throwable)e2);
            }
        }
        return logTypes;
    }

    protected List<CustomLogType> loadBuiltinLogTypesMetadata() throws URISyntaxException, IOException {
        ArrayList<CustomLogType> customLogTypes = new ArrayList<CustomLogType>();
        String url = Objects.requireNonNull(BuiltinLogTypeLoader.class.getClassLoader().getResource(BASE_PATH), "Built-in log type metadata file not found").toURI().toString();
        Path dirPath = null;
        if (url.contains("!")) {
            String[] paths = url.split("!");
            dirPath = FileUtils.getFs().getPath(paths[1], new String[0]);
        } else {
            dirPath = Path.of(url, new String[0]);
        }
        Stream<Path> folder = Files.list(dirPath);
        Path logTypePath = (Path)folder.filter(e -> e.toString().endsWith("logtypes.json")).collect(Collectors.toList()).get(0);
        try (InputStream is = BuiltinLogTypeLoader.class.getResourceAsStream(logTypePath.toString());){
            String logTypeFilePayload = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
            if (logTypeFilePayload != null) {
                Map logTypeFileAsMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)logTypeFilePayload, (boolean)false);
                for (Map.Entry logType : logTypeFileAsMap.entrySet()) {
                    customLogTypes.add(new CustomLogType((Map)logType.getValue()));
                }
            }
        }
        catch (Exception e2) {
            throw new SettingsException("Failed to load builtin log types", (Throwable)e2);
        }
        return customLogTypes;
    }

    protected void doStart() {
        this.ensureLogTypesLoaded();
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }
}

