/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.STIX2IOCDto;
import org.opensearch.securityanalytics.threatIntel.model.Source;

public class IocUploadSource
extends Source
implements Writeable,
ToXContent {
    public static final String IOCS_FIELD = "iocs";
    public static final String FILE_NAME_FIELD = "file_name";
    private String fileName;
    private List<STIX2IOCDto> iocs;

    public IocUploadSource(String fileName, List<STIX2IOCDto> iocs) {
        this.fileName = fileName;
        this.iocs = iocs;
    }

    public IocUploadSource(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), Collections.unmodifiableList(sin.readList(STIX2IOCDto::new)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.fileName);
        out.writeCollection(this.iocs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("ioc_upload");
        if (this.fileName == null) {
            builder.nullField(FILE_NAME_FIELD);
        } else {
            builder.field(FILE_NAME_FIELD, this.fileName);
        }
        builder.field(IOCS_FIELD, this.iocs);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    String name() {
        return "ioc_upload";
    }

    public static IocUploadSource parse(XContentParser xcp) throws IOException {
        String fileName = null;
        ArrayList<STIX2IOCDto> iocs = null;
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "file_name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        fileName = null;
                        break;
                    }
                    fileName = xcp.text();
                    break;
                }
                case "iocs": {
                    iocs = new ArrayList<STIX2IOCDto>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        iocs.add(STIX2IOCDto.parse(xcp, null, null));
                    }
                    break;
                }
            }
        }
        return new IocUploadSource(fileName, iocs);
    }

    public List<STIX2IOCDto> getIocs() {
        return this.iocs;
    }

    public void setIocs(List<STIX2IOCDto> iocs) {
        this.iocs = iocs;
    }

    public String getFileName() {
        return this.fileName;
    }
}

