/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.util.Map;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class TIFMetadata
implements Writeable,
ToXContent {
    private static final ParseField FEED_ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField URL_FIELD = new ParseField("url", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField ORGANIZATION_FIELD = new ParseField("organization", new String[0]);
    private static final ParseField DESCRIPTION_FIELD = new ParseField("description", new String[0]);
    private static final ParseField FEED_FORMAT = new ParseField("feed_format", new String[0]);
    private static final ParseField IOC_TYPE_FIELD = new ParseField("ioc_type", new String[0]);
    private static final ParseField IOC_COL_FIELD = new ParseField("ioc_col", new String[0]);
    private static final ParseField HAS_HEADER_FIELD = new ParseField("has_header", new String[0]);
    private String feedId;
    private String url;
    private String name;
    private String organization;
    private String description;
    private String feedType;
    private Integer iocCol;
    private String iocType;
    private Boolean hasHeader;
    public static final ConstructingObjectParser<TIFMetadata, Void> PARSER = new ConstructingObjectParser("tif_metadata", true, args -> {
        String feedId = (String)args[0];
        String url = (String)args[1];
        String name = (String)args[2];
        String organization = (String)args[3];
        String description = (String)args[4];
        String feedType = (String)args[5];
        String containedIocs = (String)args[6];
        Integer iocCol = Integer.parseInt((String)args[7]);
        Boolean hasHeader = (Boolean)args[8];
        return new TIFMetadata(feedId, url, name, organization, description, feedType, containedIocs, iocCol, hasHeader);
    });

    public TIFMetadata(Map<String, Object> input) {
        this(input.get(FEED_ID_FIELD.getPreferredName()).toString(), input.get(URL_FIELD.getPreferredName()).toString(), input.get(NAME_FIELD.getPreferredName()).toString(), input.get(ORGANIZATION_FIELD.getPreferredName()).toString(), input.get(DESCRIPTION_FIELD.getPreferredName()).toString(), input.get(FEED_FORMAT.getPreferredName()).toString(), input.get(IOC_TYPE_FIELD.getPreferredName()).toString(), Integer.parseInt(input.get(IOC_COL_FIELD.getPreferredName()).toString()), (Boolean)input.get(HAS_HEADER_FIELD.getPreferredName()));
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public Integer getIocCol() {
        return this.iocCol;
    }

    public String getIocType() {
        return this.iocType;
    }

    public Boolean hasHeader() {
        return this.hasHeader;
    }

    public TIFMetadata(String feedId, String url, String name, String organization, String description, String feedType, String iocType, Integer iocCol, Boolean hasHeader) {
        this.feedId = feedId;
        this.url = url;
        this.name = name;
        this.organization = organization;
        this.description = description;
        this.feedType = feedType;
        this.iocType = iocType;
        this.iocCol = iocCol;
        this.hasHeader = hasHeader;
    }

    public TIFMetadata(StreamInput in) throws IOException {
        this.feedId = in.readString();
        this.url = in.readString();
        this.name = in.readString();
        this.organization = in.readString();
        this.description = in.readString();
        this.feedType = in.readString();
        this.iocType = in.readString();
        this.iocCol = in.readInt();
        this.hasHeader = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.feedId);
        out.writeString(this.url);
        out.writeString(this.name);
        out.writeString(this.organization);
        out.writeString(this.description);
        out.writeString(this.feedType);
        out.writeString(this.iocType);
        out.writeInt(this.iocCol.intValue());
        out.writeBoolean(this.hasHeader.booleanValue());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEED_ID_FIELD.getPreferredName(), this.feedId);
        builder.field(URL_FIELD.getPreferredName(), this.url);
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(ORGANIZATION_FIELD.getPreferredName(), this.organization);
        builder.field(DESCRIPTION_FIELD.getPreferredName(), this.description);
        builder.field(FEED_FORMAT.getPreferredName(), this.feedType);
        builder.field(IOC_TYPE_FIELD.getPreferredName(), this.iocType);
        builder.field(IOC_COL_FIELD.getPreferredName(), this.iocCol);
        builder.field(HAS_HEADER_FIELD.getPreferredName(), this.hasHeader);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEED_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), URL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ORGANIZATION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEED_FORMAT);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), IOC_TYPE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), IOC_COL_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), HAS_HEADER_FIELD);
    }
}

