/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.sacommons.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.threatIntel.iocscan.dto.PerIocTypeScanInputDto;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelMonitorDtoInterface;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelTriggerDto;

public class ThreatIntelMonitorDto
implements Writeable,
ToXContentObject,
ThreatIntelMonitorDtoInterface {
    private static final String ID = "id";
    public static final String PER_IOC_TYPE_SCAN_INPUT_FIELD = "per_ioc_type_scan_input_list";
    public static final String INDICES = "indices";
    public static final String TRIGGERS_FIELD = "triggers";
    private final String id;
    private final String name;
    private final List<PerIocTypeScanInputDto> perIocTypeScanInputList;
    private final Schedule schedule;
    private final boolean enabled;
    private final User user;
    private final List<String> indices;
    private final List<ThreatIntelTriggerDto> triggers;

    public ThreatIntelMonitorDto(String id, String name, List<PerIocTypeScanInputDto> perIocTypeScanInputList, Schedule schedule, boolean enabled, User user, List<ThreatIntelTriggerDto> triggers) {
        this.id = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString() : id;
        this.name = name;
        this.perIocTypeScanInputList = perIocTypeScanInputList;
        this.schedule = schedule;
        this.enabled = enabled;
        this.user = user;
        this.indices = this.getIndices(perIocTypeScanInputList);
        this.triggers = triggers;
    }

    private List<String> getIndices(List<PerIocTypeScanInputDto> perIocTypeScanInputList) {
        if (perIocTypeScanInputList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> uniqueValues = new HashSet<String>();
        for (PerIocTypeScanInputDto dto : perIocTypeScanInputList) {
            Map<Object, Object> indexToFieldsMap = dto.getIndexToFieldsMap() == null ? Collections.emptyMap() : dto.getIndexToFieldsMap();
            for (String string : indexToFieldsMap.keySet()) {
                if (!uniqueValues.add(string)) continue;
                list.add(string);
            }
        }
        return list;
    }

    public ThreatIntelMonitorDto(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readString(), sin.readList(PerIocTypeScanInputDto::new), Schedule.readFrom((StreamInput)sin), sin.readBoolean(), sin.readBoolean() ? new User(sin) : null, sin.readList(ThreatIntelTriggerDto::new));
    }

    public static ThreatIntelMonitorDto readFrom(StreamInput sin) throws IOException {
        return new ThreatIntelMonitorDto(sin);
    }

    public static ThreatIntelMonitorDto parse(XContentParser xcp, String id, Long version) throws IOException {
        String name = null;
        ArrayList<PerIocTypeScanInputDto> inputs = new ArrayList<PerIocTypeScanInputDto>();
        Schedule schedule = null;
        Boolean enabled = null;
        User user = null;
        ArrayList<ThreatIntelTriggerDto> triggers = new ArrayList<ThreatIntelTriggerDto>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = xcp.text();
                    continue block18;
                }
                case "name": {
                    name = xcp.text();
                    continue block18;
                }
                case "per_ioc_type_scan_input_list": {
                    Object input;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        input = PerIocTypeScanInputDto.parse(xcp);
                        inputs.add((PerIocTypeScanInputDto)input);
                    }
                    continue block18;
                }
                case "triggers": {
                    Object input;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        input = ThreatIntelTriggerDto.parse(xcp);
                        triggers.add((ThreatIntelTriggerDto)input);
                    }
                    continue block18;
                }
                case "schedule": {
                    schedule = Schedule.parse((XContentParser)xcp);
                    continue block18;
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    continue block18;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block18;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelMonitorDto(id, name, inputs, schedule, enabled != null ? enabled : false, user, triggers);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.id);
        out.writeString(this.name);
        out.writeList(this.perIocTypeScanInputList);
        if (this.schedule instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.schedule.writeTo(out);
        out.writeBoolean(this.enabled);
        this.user.writeTo(out);
        out.writeStringCollection(this.indices);
        out.writeList(this.triggers);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(ID, this.id).field("name", this.name).field(PER_IOC_TYPE_SCAN_INPUT_FIELD, this.perIocTypeScanInputList).field("schedule", (ToXContent)this.schedule).field("enabled", this.enabled).field("user", (ToXContent)this.user).field(INDICES, this.indices).field(TRIGGERS_FIELD, this.triggers).endObject();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<PerIocTypeScanInputDto> getPerIocTypeScanInputList() {
        return this.perIocTypeScanInputList;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public User getUser() {
        return this.user;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<ThreatIntelTriggerDto> getTriggers() {
        return this.triggers;
    }
}

