/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.llm;

import java.util.List;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.searchpipelines.questionanswering.generative.llm.ChatCompletionInput;
import org.opensearch.searchpipelines.questionanswering.generative.llm.Llm;

public class LlmIOUtil {
    public static final String BEDROCK_PROVIDER_PREFIX = "bedrock/";
    public static final String COHERE_PROVIDER_PREFIX = "cohere/";

    public static ChatCompletionInput createChatCompletionInput(String llmModel, String question, List<Interaction> chatHistory, List<String> contexts, int timeoutInSeconds, String llmResponseField) {
        return LlmIOUtil.createChatCompletionInput("Generate a concise and informative answer in less than 100 words for the given question, taking into context: - An enumerated list of search results- A rephrase of the question that was used to generate the search results- The conversation historyCite search results using [${number}] notation.Do not repeat yourself, and NEVER repeat anything in the chat history.If there are any necessary steps or procedures in your answer, enumerate them.", null, llmModel, question, chatHistory, contexts, timeoutInSeconds, llmResponseField);
    }

    public static ChatCompletionInput createChatCompletionInput(String systemPrompt, String userInstructions, String llmModel, String question, List<Interaction> chatHistory, List<String> contexts, int timeoutInSeconds, String llmResponseField) {
        Llm.ModelProvider provider = null;
        if (llmResponseField == null) {
            provider = Llm.ModelProvider.OPENAI;
            if (llmModel != null) {
                if (llmModel.startsWith(BEDROCK_PROVIDER_PREFIX)) {
                    provider = Llm.ModelProvider.BEDROCK;
                } else if (llmModel.startsWith(COHERE_PROVIDER_PREFIX)) {
                    provider = Llm.ModelProvider.COHERE;
                }
            }
        }
        return new ChatCompletionInput(llmModel, question, chatHistory, contexts, timeoutInSeconds, systemPrompt, userInstructions, provider, llmResponseField);
    }
}

