/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.utils.StringUtils;

public class LLMSpec
implements ToXContentObject {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String PARAMETERS_FIELD = "parameters";
    private String modelId;
    private Map<String, String> parameters;

    public LLMSpec(String modelId, Map<String, String> parameters) {
        if (modelId == null) {
            throw new IllegalArgumentException("model id is null");
        }
        this.modelId = modelId;
        this.parameters = parameters;
    }

    public LLMSpec(StreamInput input) throws IOException {
        this.modelId = input.readString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        if (this.parameters != null && this.parameters.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        builder.endObject();
        return builder;
    }

    public static LLMSpec parse(XContentParser parser) throws IOException {
        String modelId = null;
        Map<String, String> parameters = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block8;
                }
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return LLMSpec.builder().modelId(modelId).parameters(parameters).build();
    }

    public static LLMSpec fromStream(StreamInput in) throws IOException {
        LLMSpec toolSpec = new LLMSpec(in);
        return toolSpec;
    }

    @Generated
    public static LLMSpecBuilder builder() {
        return new LLMSpecBuilder();
    }

    @Generated
    public LLMSpecBuilder toBuilder() {
        return new LLMSpecBuilder().modelId(this.modelId).parameters(this.parameters);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LLMSpec)) {
            return false;
        }
        LLMSpec other = (LLMSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LLMSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public static class LLMSpecBuilder {
        @Generated
        private String modelId;
        @Generated
        private Map<String, String> parameters;

        @Generated
        LLMSpecBuilder() {
        }

        @Generated
        public LLMSpecBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public LLMSpecBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public LLMSpec build() {
            return new LLMSpec(this.modelId, this.parameters);
        }

        @Generated
        public String toString() {
            return "LLMSpec.LLMSpecBuilder(modelId=" + this.modelId + ", parameters=" + String.valueOf(this.parameters) + ")";
        }
    }
}

