/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.util.range;

import java.util.Objects;

public class Range {
    private final double lowerBound;
    private final double upperBound;
    private final double threshold;

    public Range(double lowerBound, double upperBound, double threshold) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.threshold = threshold;
    }

    public boolean contains(double value) {
        return value >= this.lowerBound && value <= this.upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Double.compare(range.getLowerBound(), this.getLowerBound()) == 0 && Double.compare(range.getUpperBound(), this.getUpperBound()) == 0 && Double.compare(range.getThreshold(), this.getThreshold()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getLowerBound(), this.getUpperBound(), this.getThreshold());
    }

    public String toString() {
        return String.format("Range{lowerBound=%s, upperBound=%s, threshold=%s}", this.lowerBound, this.upperBound, this.threshold);
    }
}

