/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.filedialog;

import jadx.gui.ui.MainWindow;
import jadx.gui.ui.filedialog.CustomFileChooser;
import jadx.gui.ui.filedialog.CustomFileDialog;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.utils.NLS;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FileDialogWrapper {
    private final MainWindow mainWindow;
    private boolean isOpen;
    private String title;
    private List<String> fileExtList;
    private int selectionMode = 2;
    @Nullable
    private Path currentDir;
    @Nullable
    private Path selectedFile;

    public FileDialogWrapper(MainWindow mainWindow, FileOpenMode mode) {
        this.mainWindow = mainWindow;
        this.initForMode(mode);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFileExtList(List<String> fileExtList) {
        this.fileExtList = fileExtList;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setSelectedFile(Path path) {
        this.selectedFile = path;
    }

    public void setCurrentDir(Path currentDir) {
        this.currentDir = currentDir;
    }

    public List<Path> show() {
        if (this.mainWindow.getSettings().isUseAlternativeFileDialog()) {
            return new CustomFileDialog(this).showDialog();
        }
        return new CustomFileChooser(this).showDialog();
    }

    private void initForMode(FileOpenMode mode) {
        switch (mode) {
            case OPEN: 
            case OPEN_PROJECT: 
            case ADD: {
                if (mode == FileOpenMode.OPEN_PROJECT) {
                    this.fileExtList = Collections.singletonList("jadx");
                    this.title = NLS.str("file.open_title");
                } else {
                    this.fileExtList = new ArrayList<String>(Arrays.asList("apk", "dex", "jar", "class", "smali", "zip", "xapk", "aar", "arsc"));
                    if (mode == FileOpenMode.OPEN) {
                        this.fileExtList.addAll(Arrays.asList("jadx", "aab"));
                        this.title = NLS.str("file.open_title");
                    } else {
                        this.title = NLS.str("file.add_files_action");
                    }
                }
                this.selectionMode = 2;
                this.currentDir = this.mainWindow.getSettings().getLastOpenFilePath();
                this.isOpen = true;
                break;
            }
            case SAVE_PROJECT: {
                this.title = NLS.str("file.save_project");
                this.fileExtList = Collections.singletonList("jadx");
                this.selectionMode = 0;
                this.currentDir = this.mainWindow.getSettings().getLastSaveFilePath();
                this.isOpen = false;
                break;
            }
            case EXPORT: {
                this.title = NLS.str("file.save_all_msg");
                this.fileExtList = Collections.emptyList();
                this.selectionMode = 1;
                this.currentDir = this.mainWindow.getSettings().getLastSaveFilePath();
                this.isOpen = false;
                break;
            }
            case CUSTOM_SAVE: {
                this.isOpen = false;
                this.currentDir = this.mainWindow.getSettings().getLastSaveFilePath();
                break;
            }
            case CUSTOM_OPEN: {
                this.isOpen = true;
                this.currentDir = this.mainWindow.getSettings().getLastOpenFilePath();
            }
        }
    }

    public Path getCurrentDir() {
        return this.currentDir;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getFileExtList() {
        return this.fileExtList;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public Path getSelectedFile() {
        return this.selectedFile;
    }
}

