/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.impl;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class StreamExceptionBase
extends XMLStreamException {
    final String mMsg;

    public StreamExceptionBase(String msg2) {
        super(msg2);
        this.mMsg = msg2;
    }

    public StreamExceptionBase(Throwable th) {
        super(th.getMessage(), th);
        this.mMsg = th.getMessage();
        if (this.getCause() == null) {
            this.initCause(th);
        }
    }

    public StreamExceptionBase(String msg2, Location loc) {
        super(msg2, loc);
        this.mMsg = msg2;
    }

    @Override
    public String getMessage() {
        String locMsg = this.getLocationDesc();
        if (locMsg == null) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder(this.mMsg.length() + locMsg.length() + 20);
        sb.append(this.mMsg);
        sb.append('\n');
        sb.append(" at ");
        sb.append(locMsg);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected String getLocationDesc() {
        Location loc = this.getLocation();
        return loc == null ? null : loc.toString();
    }
}

