/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.DoubleStream;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

class DrawSnapHelper {
    private final DrawAction drawAction;
    private static final String DRAW_ANGLESNAP_ANGLES = "draw.anglesnap.angles";
    private boolean snapOn;
    private boolean active;
    private boolean fixed;
    private boolean absoluteFix;
    EastNorth dir2;
    private EastNorth projected;
    private String labelText;
    private double lastAngle;
    private double customBaseHeading = -1.0;
    private EastNorth segmentPoint1;
    private EastNorth segmentPoint2;
    private EastNorth projectionSource;
    private double[] snapAngles;
    private double pe;
    private double pn;
    private double e0;
    private double n0;
    private final String fixFmt = "%d " + I18n.tr("FIX", new Object[0]);
    private JCheckBoxMenuItem checkBox;
    final MouseListener anglePopupListener;

    DrawSnapHelper(final DrawAction drawAction) {
        this.drawAction = drawAction;
        this.anglePopupListener = new PopupMenuLauncher(new AnglePopupMenu(this)){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1) {
                    DrawSnapHelper.this.toggleSnapping();
                    drawAction.updateStatusLine();
                }
            }
        };
    }

    public void init() {
        this.snapOn = false;
        this.checkBox.setState(this.snapOn);
        this.fixed = false;
        this.absoluteFix = false;
        this.computeSnapAngles();
        Preferences.main().addWeakKeyPreferenceChangeListener(DRAW_ANGLESNAP_ANGLES, e -> this.computeSnapAngles());
    }

    private void computeSnapAngles() {
        this.snapAngles = Config.getPref().getList(DRAW_ANGLESNAP_ANGLES, Arrays.asList("0", "30", "45", "60", "90", "120", "135", "150", "180")).stream().mapToDouble(DrawSnapHelper::parseSnapAngle).flatMap(s -> DoubleStream.of(s, 360.0 - s)).toArray();
    }

    private static double parseSnapAngle(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            Logging.warn("Incorrect number in draw.anglesnap.angles preferences: {0}", string);
            return 0.0;
        }
    }

    public void saveAngles(String ... angles) {
        Config.getPref().putList(DRAW_ANGLESNAP_ANGLES, Arrays.asList(angles));
    }

    public void setMenuCheckBox(JCheckBoxMenuItem checkBox) {
        this.checkBox = checkBox;
    }

    public void drawIfNeeded(Graphics2D g2, MapViewState mv) {
        MapViewPath b;
        if (!this.snapOn || !this.active) {
            return;
        }
        MapViewState.MapViewPoint p1 = mv.getPointFor(this.drawAction.getCurrentBaseNode());
        MapViewState.MapViewPoint p2 = mv.getPointFor(this.dir2);
        MapViewState.MapViewPoint p3 = mv.getPointFor(this.projected);
        if (DrawAction.DRAW_CONSTRUCTION_GEOMETRY.get().booleanValue()) {
            g2.setColor(DrawAction.SNAP_HELPER_COLOR.get());
            g2.setStroke(DrawAction.HELPER_STROKE.get());
            b = new MapViewPath(mv);
            b.moveTo(p2);
            if (this.absoluteFix) {
                b.lineTo(p2.interpolate(p1, 2.0));
            } else {
                b.lineTo(p3);
            }
            g2.draw(b);
        }
        if (this.projectionSource != null) {
            g2.setColor(DrawAction.SNAP_HELPER_COLOR.get());
            g2.setStroke(DrawAction.HELPER_STROKE.get());
            b = new MapViewPath(mv);
            b.moveTo(p3);
            b.lineTo(this.projectionSource);
            g2.draw(b);
        }
        if (this.customBaseHeading >= 0.0) {
            g2.setColor(DrawAction.HIGHLIGHT_COLOR.get());
            g2.setStroke(DrawAction.HIGHLIGHT_STROKE.get());
            b = new MapViewPath(mv);
            b.moveTo(this.segmentPoint1);
            b.lineTo(this.segmentPoint2);
            g2.draw(b);
        }
        g2.setColor(DrawAction.RUBBER_LINE_COLOR.get());
        g2.setStroke(DrawAction.RUBBER_LINE_STROKE.get());
        b = new MapViewPath(mv);
        b.moveTo(p1);
        b.lineTo(p3);
        g2.draw(b);
        g2.drawString(this.labelText, (int)p3.getInViewX() - 5, (int)p3.getInViewY() + 20);
        if (DrawAction.SHOW_PROJECTED_POINT.get().booleanValue()) {
            g2.setStroke(DrawAction.RUBBER_LINE_STROKE.get());
            g2.draw(new MapViewPath(mv).shapeAround(p3, SymbolShape.CIRCLE, 10.0));
        }
        g2.setColor(DrawAction.SNAP_HELPER_COLOR.get());
        g2.setStroke(DrawAction.HELPER_STROKE.get());
    }

    public void checkAngleSnapping(EastNorth currentEN, double baseHeading, double curHeading) {
        double activeBaseHeading;
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth p0 = this.drawAction.getCurrentBaseNode().getEastNorth();
        EastNorth snapPoint = currentEN;
        double angle = -1.0;
        double d = activeBaseHeading = this.customBaseHeading >= 0.0 ? this.customBaseHeading : baseHeading;
        if (this.snapOn && activeBaseHeading >= 0.0) {
            double nearestAngle;
            angle = curHeading - activeBaseHeading;
            if (angle < 0.0) {
                angle += 360.0;
            }
            if (angle > 360.0) {
                angle = 0.0;
            }
            if (this.fixed) {
                nearestAngle = this.lastAngle;
                this.active = true;
            } else {
                nearestAngle = this.getNearestAngle(angle);
                if (DrawSnapHelper.getAngleDelta(nearestAngle, angle) < DrawAction.SNAP_ANGLE_TOLERANCE.get()) {
                    this.active = this.customBaseHeading >= 0.0 || Math.abs(nearestAngle - 180.0) > 0.001;
                    this.lastAngle = nearestAngle;
                } else {
                    this.active = false;
                }
            }
            if (this.active) {
                this.e0 = p0.east();
                this.n0 = p0.north();
                this.buildLabelText(nearestAngle <= 180.0 ? nearestAngle : nearestAngle - 360.0);
                double phi = (nearestAngle + activeBaseHeading) * Math.PI / 180.0;
                this.pe = Math.sin(phi);
                this.pn = Math.cos(phi);
                double scale = 20.0 * mapView.getDist100Pixel();
                this.dir2 = new EastNorth(this.e0 + scale * this.pe, this.n0 + scale * this.pn);
                snapPoint = this.getSnapPoint(currentEN);
            } else {
                this.noSnapNow();
            }
        }
        LatLon mouseLatLon = mapView.getProjection().eastNorth2latlon(snapPoint);
        double distance = this.drawAction.getCurrentBaseNode().getCoor().greatCircleDistance(mouseLatLon);
        double hdg = Utils.toDegrees(p0.heading(snapPoint));
        if (baseHeading >= 0.0) {
            angle = hdg - baseHeading;
            if (angle < 0.0) {
                angle += 360.0;
            }
            if (angle > 360.0) {
                angle = 0.0;
            }
        }
        DrawAction.showStatusInfo(angle, hdg, distance, this.isSnapOn());
    }

    private void buildLabelText(double nearestAngle) {
        this.labelText = DrawAction.SHOW_ANGLE.get().booleanValue() ? (this.fixed ? (this.absoluteFix ? "=" : String.format(this.fixFmt, (int)nearestAngle)) : String.format("%d", (int)nearestAngle)) : (this.fixed ? (this.absoluteFix ? "=" : String.format(I18n.tr("FIX", new Object[0]), 0)) : "");
    }

    public EastNorth getSnapPoint(EastNorth p) {
        DataSet ds;
        Collection selectedWays;
        if (!this.active) {
            return p;
        }
        double de = p.east() - this.e0;
        double dn = p.north() - this.n0;
        double l = de * this.pe + dn * this.pn;
        double delta = MainApplication.getMap().mapView.getDist100Pixel() / 20.0;
        if (!this.absoluteFix && l < delta) {
            this.active = false;
            return p;
        }
        this.projectionSource = null;
        if (DrawAction.SNAP_TO_PROJECTIONS.get().booleanValue() && (selectedWays = (ds = this.drawAction.getLayerManager().getActiveDataSet()).getSelectedWays()).size() == 1) {
            Way w = (Way)selectedWays.iterator().next();
            ArrayList<EastNorth> pointsToProject = new ArrayList<EastNorth>();
            if (w.getNodesCount() < 1000) {
                for (Node n : w.getNodes()) {
                    pointsToProject.add(n.getEastNorth());
                }
            }
            if (this.customBaseHeading >= 0.0) {
                pointsToProject.add(this.segmentPoint1);
                pointsToProject.add(this.segmentPoint2);
            }
            EastNorth enOpt = null;
            double dOpt = 100000.0;
            for (EastNorth en : pointsToProject) {
                double l1 = (en.east() - this.e0) * this.pe + (en.north() - this.n0) * this.pn;
                double d1 = Math.abs(l1 - l);
                if (!(d1 < delta) || !(d1 < dOpt)) continue;
                l = l1;
                enOpt = en;
                dOpt = d1;
            }
            if (enOpt != null) {
                this.projectionSource = enOpt;
            }
        }
        this.projected = new EastNorth(this.e0 + l * this.pe, this.n0 + l * this.pn);
        return this.projected;
    }

    void noSnapNow() {
        this.active = false;
        this.dir2 = null;
        this.projected = null;
        this.labelText = null;
    }

    void setBaseSegment(WaySegment seg) {
        if (seg == null) {
            return;
        }
        this.segmentPoint1 = seg.getFirstNode().getEastNorth();
        this.segmentPoint2 = seg.getSecondNode().getEastNorth();
        double hdg = this.segmentPoint1.heading(this.segmentPoint2);
        if ((hdg = Utils.toDegrees(hdg)) < 0.0) {
            hdg += 360.0;
        }
        if (hdg > 360.0) {
            hdg -= 360.0;
        }
        this.customBaseHeading = hdg;
    }

    void enableSnapping() {
        this.snapOn = true;
        this.checkBox.setState(this.snapOn);
        this.customBaseHeading = -1.0;
        this.unsetFixedMode();
    }

    void toggleSnapping() {
        this.snapOn = !this.snapOn;
        this.checkBox.setState(this.snapOn);
        this.customBaseHeading = -1.0;
        this.unsetFixedMode();
    }

    void setFixedMode() {
        if (this.active) {
            this.fixed = true;
        }
    }

    void unsetFixedMode() {
        this.fixed = false;
        this.absoluteFix = false;
        this.lastAngle = 0.0;
        this.active = false;
    }

    boolean isActive() {
        return this.active;
    }

    boolean isSnapOn() {
        return this.snapOn;
    }

    private double getNearestAngle(double angle) {
        double bestAngle = DoubleStream.of(this.snapAngles).boxed().min(Comparator.comparing(snapAngle -> DrawSnapHelper.getAngleDelta(angle, snapAngle))).orElse(0.0);
        if (Math.abs(bestAngle - 360.0) < 0.001) {
            bestAngle = 0.0;
        }
        return bestAngle;
    }

    private static double getAngleDelta(double a, double b) {
        double delta = Math.abs(a - b);
        if (delta > 180.0) {
            return 360.0 - delta;
        }
        return delta;
    }

    void unFixOrTurnOff() {
        if (this.absoluteFix) {
            this.unsetFixedMode();
        } else {
            this.toggleSnapping();
        }
    }

    private static final class AnglePopupMenu
    extends JPopupMenu {
        private AnglePopupMenu(DrawSnapHelper snapHelper) {
            JCheckBoxMenuItem repeatedCb = new JCheckBoxMenuItem(new RepeatedAction(snapHelper));
            JCheckBoxMenuItem helperCb = new JCheckBoxMenuItem(new HelperAction(snapHelper));
            JCheckBoxMenuItem projectionCb = new JCheckBoxMenuItem(new ProjectionAction(snapHelper));
            helperCb.setState(DrawAction.DRAW_CONSTRUCTION_GEOMETRY.get());
            projectionCb.setState(DrawAction.SNAP_TO_PROJECTIONS.get());
            repeatedCb.setState(DrawAction.USE_REPEATED_SHORTCUT.get());
            this.add(repeatedCb);
            this.add(helperCb);
            this.add(projectionCb);
            this.add(new DisableAction(snapHelper));
            this.add(new Snap90DegreesAction(snapHelper));
            this.add(new Snap45DegreesAction(snapHelper));
            this.add(new Snap30DegreesAction(snapHelper));
        }
    }

    private static final class Snap30DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap30DegreesAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("0,30,45,60,90,...", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.snapHelper.saveAngles("0", "30", "45", "60", "90", "120", "135", "150", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class Snap45DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap45DegreesAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("0,45,90,...", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.snapHelper.saveAngles("0", "45", "90", "135", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class Snap90DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap90DegreesAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("0,90,...", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.snapHelper.saveAngles("0", "90", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class DisableAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        DisableAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("Disable", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.snapHelper.saveAngles("180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class ProjectionAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        ProjectionAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("Snap to node projections", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
            DrawAction.SNAP_TO_PROJECTIONS.put(sel);
            this.snapHelper.enableSnapping();
        }
    }

    private static final class HelperAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        HelperAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("Show helper geometry", new Object[0]));
            this.snapHelper = snapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
            DrawAction.DRAW_CONSTRUCTION_GEOMETRY.put(sel);
            DrawAction.SHOW_PROJECTED_POINT.put(sel);
            DrawAction.SHOW_ANGLE.put(sel);
            this.snapHelper.enableSnapping();
        }
    }

    private static final class RepeatedAction
    extends AbstractAction {
        RepeatedAction(DrawSnapHelper snapHelper) {
            super(I18n.tr("Toggle snapping by {0}", snapHelper.drawAction.getShortcut().getKeyText()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
            DrawAction.USE_REPEATED_SHORTCUT.put(sel);
        }
    }
}

