/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class EchoStream
extends Stream {
    private final Stream in;
    private final Stream out;
    private int unreadChar = -1;
    private static final Primitive MAKE_ECHO_STREAM = new Primitive("make-echo-stream", "input-stream output-stream"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Stream input = Lisp.checkStream(first);
            Stream output = Lisp.checkStream(second);
            return new EchoStream(input, output);
        }
    };
    private static final Primitive ECHO_STREAM_INPUT_STREAM = new Primitive("echo-stream-input-stream", "echo-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof EchoStream) {
                return ((EchoStream)arg).getInputStream();
            }
            return Lisp.type_error(arg, Symbol.ECHO_STREAM);
        }
    };
    private static final Primitive ECHO_STREAM_OUTPUT_STREAM = new Primitive("echo-stream-output-stream", "echo-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof EchoStream) {
                return ((EchoStream)arg).getOutputStream();
            }
            return Lisp.type_error(arg, Symbol.ECHO_STREAM);
        }
    };

    public EchoStream(Stream in, Stream out) {
        super(Symbol.ECHO_STREAM);
        this.in = in;
        this.out = out;
    }

    public EchoStream(Stream in, Stream out, boolean interactive) {
        super(Symbol.ECHO_STREAM);
        this.in = in;
        this.out = out;
        this.setInteractive(interactive);
    }

    @Override
    public LispObject getElementType() {
        LispObject otype;
        LispObject itype = this.in.getElementType();
        if (itype.equal(otype = this.out.getElementType())) {
            return itype;
        }
        return Symbol.NULL;
    }

    public Stream getInputStream() {
        return this.in;
    }

    public Stream getOutputStream() {
        return this.out;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.ECHO_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.ECHO_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.ECHO_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.ECHO_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public boolean isInputStream() {
        return true;
    }

    @Override
    public boolean isOutputStream() {
        return true;
    }

    @Override
    public boolean isCharacterInputStream() {
        return this.in.isCharacterInputStream();
    }

    @Override
    public boolean isBinaryInputStream() {
        return this.in.isBinaryInputStream();
    }

    @Override
    public boolean isCharacterOutputStream() {
        return this.out.isCharacterOutputStream();
    }

    @Override
    public boolean isBinaryOutputStream() {
        return this.out.isBinaryOutputStream();
    }

    @Override
    protected int _readChar() throws IOException {
        int n = this.in._readChar();
        if (n >= 0) {
            if (this.unreadChar < 0) {
                this.out._writeChar((char)n);
            } else {
                this.unreadChar = -1;
            }
        }
        return n;
    }

    @Override
    protected void _unreadChar(int n) throws IOException {
        this.in._unreadChar(n);
        this.unreadChar = n;
    }

    @Override
    protected boolean _charReady() throws IOException {
        return this.in._charReady();
    }

    @Override
    public void _writeChar(char c) {
        this.out._writeChar(c);
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        this.out._writeChars(chars, start, end);
    }

    @Override
    public void _writeString(String s) {
        this.out._writeString(s);
    }

    @Override
    public void _writeLine(String s) {
        this.out._writeLine(s);
    }

    @Override
    public int _readByte() {
        int n = this.in._readByte();
        if (n >= 0) {
            this.out._writeByte(n);
        }
        return n;
    }

    @Override
    public void _writeByte(int n) {
        this.out._writeByte(n);
    }

    @Override
    public void _finishOutput() {
        this.out._finishOutput();
    }

    @Override
    public void _clearInput() {
        this.in._clearInput();
    }

    @Override
    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    @Override
    public LispObject listen() {
        return this.in.listen();
    }

    @Override
    public LispObject freshLine() {
        return this.out.freshLine();
    }
}

