/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergerows;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mergerows.MergeRows;
import org.pentaho.di.trans.steps.mergerows.MergeRowsData;
import org.pentaho.di.trans.steps.mergerows.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String referenceStepName;
    private StepMeta referenceStepMeta;
    private String compareStepName;
    private StepMeta compareStepMeta;
    private String flagField;
    private String[] keyFields;
    private String[] valueFields;

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    public String[] getValueFields() {
        return this.valueFields;
    }

    public void setValueFields(String[] valueFields) {
        this.valueFields = valueFields;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public String getCompareStepName() {
        if (this.compareStepMeta != null && this.compareStepMeta.getName() != null && this.compareStepMeta.getName().length() > 0) {
            return this.compareStepMeta.getName();
        }
        return null;
    }

    public String getReferenceStepName() {
        if (this.referenceStepMeta != null && this.referenceStepMeta.getName() != null && this.referenceStepMeta.getName().length() > 0) {
            return this.referenceStepMeta.getName();
        }
        return null;
    }

    public void setCompareStepName(String sendFalseStepname) {
        this.compareStepName = sendFalseStepname;
    }

    public void setReferenceStepName(String sendTrueStepname) {
        this.referenceStepName = sendTrueStepname;
    }

    public StepMeta getCompareStepMeta() {
        return this.compareStepMeta;
    }

    public StepMeta getReferenceStepMeta() {
        return this.referenceStepMeta;
    }

    public void setCompareStepMeta(StepMeta sendFalseStep) {
        this.compareStepMeta = sendFalseStep;
    }

    public void setReferenceStepMeta(StepMeta sendTrueStep) {
        this.referenceStepMeta = sendTrueStep;
    }

    public String getFlagField() {
        return this.flagField;
    }

    public void setFlagField(String flagField) {
        this.flagField = flagField;
    }

    public void allocate(int nrKeys, int nrValues) {
        this.keyFields = new String[nrKeys];
        this.valueFields = new String[nrValues];
    }

    @Override
    public Object clone() {
        MergeRowsMeta retval = (MergeRowsMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    <keys>" + Const.CR);
        for (i = 0; i < this.keyFields.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields[i]));
        }
        retval.append("    </keys>" + Const.CR);
        retval.append("    <values>" + Const.CR);
        for (i = 0; i < this.valueFields.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"value", (String)this.valueFields[i]));
        }
        retval.append("    </values>" + Const.CR);
        retval.append(XMLHandler.addTagValue((String)"flag_field", (String)this.flagField));
        retval.append(XMLHandler.addTagValue((String)"reference", (String)this.getReferenceStepName()));
        retval.append(XMLHandler.addTagValue((String)"compare", (String)this.getCompareStepName()));
        retval.append("    <compare>" + Const.CR);
        retval.append("    </compare>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            Node keysnode = XMLHandler.getSubNode((Node)stepnode, (String)"keys");
            Node valuesnode = XMLHandler.getSubNode((Node)stepnode, (String)"values");
            int nrKeys = XMLHandler.countNodes((Node)keysnode, (String)"key");
            int nrValues = XMLHandler.countNodes((Node)valuesnode, (String)"value");
            this.allocate(nrKeys, nrValues);
            for (i = 0; i < nrKeys; ++i) {
                Node keynode = XMLHandler.getSubNodeByNr((Node)keysnode, (String)"key", (int)i);
                this.keyFields[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            for (i = 0; i < nrValues; ++i) {
                Node valuenode = XMLHandler.getSubNodeByNr((Node)valuesnode, (String)"value", (int)i);
                this.valueFields[i] = XMLHandler.getNodeValue((Node)valuenode);
            }
            this.flagField = XMLHandler.getTagValue((Node)stepnode, (String)"flag_field");
            this.compareStepName = XMLHandler.getTagValue((Node)stepnode, (String)"compare");
            this.referenceStepName = XMLHandler.getTagValue((Node)stepnode, (String)"reference");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("MergeRowsMeta.Exception.UnableToLoadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.flagField = "flagfield";
        this.allocate(0, 0);
    }

    @Override
    public String[] getInfoSteps() {
        if (this.referenceStepMeta != null && this.compareStepMeta != null) {
            return new String[]{this.referenceStepMeta.getName(), this.compareStepMeta.getName()};
        }
        return null;
    }

    @Override
    public void setInfoSteps(StepMeta[] infoSteps) {
        if (infoSteps != null && infoSteps.length == 2) {
            this.referenceStepMeta = infoSteps[0];
            this.compareStepMeta = infoSteps[1];
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            int nrKeys = rep.countNrStepAttributes(id_step, "key_field");
            int nrValues = rep.countNrStepAttributes(id_step, "value_field");
            this.allocate(nrKeys, nrValues);
            for (i = 0; i < nrKeys; ++i) {
                this.keyFields[i] = rep.getStepAttributeString(id_step, i, "key_field");
            }
            for (i = 0; i < nrValues; ++i) {
                this.valueFields[i] = rep.getStepAttributeString(id_step, i, "value_field");
            }
            this.flagField = rep.getStepAttributeString(id_step, "flag_field");
            this.referenceStepName = rep.getStepAttributeString(id_step, "reference");
            this.compareStepName = rep.getStepAttributeString(id_step, "compare");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MergeRowsMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.keyFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_field", this.keyFields[i]);
            }
            for (i = 0; i < this.valueFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_field", this.valueFields[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "flag_field", this.flagField);
            rep.saveStepAttribute(id_transformation, id_step, "reference", this.getReferenceStepName());
            rep.saveStepAttribute(id_transformation, id_step, "compare", this.getCompareStepName());
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MergeRowsMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.referenceStepMeta = StepMeta.findStep(steps, this.referenceStepName);
        this.compareStepMeta = StepMeta.findStep(steps, this.compareStepName);
    }

    @Override
    public boolean chosesTargetSteps() {
        return false;
    }

    @Override
    public String[] getTargetSteps() {
        return null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i]);
                found = true;
            }
        }
        if (Const.isEmpty((String)this.flagField)) {
            throw new KettleStepException(Messages.getString("MergeRowsMeta.Exception.FlagFieldNotSpecified"));
        }
        ValueMeta flagFieldValue = new ValueMeta(this.flagField, 2);
        flagFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)flagFieldValue);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.getReferenceStepName() != null && this.getCompareStepName() != null) {
            CheckResult cr = new CheckResult(1, Messages.getString("MergeRowsMeta.CheckResult.SourceStepsOK"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else if (this.getReferenceStepName() == null && this.getCompareStepName() == null) {
            CheckResult cr = new CheckResult(4, Messages.getString("MergeRowsMeta.CheckResult.SourceStepsMissing"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, Messages.getString("MergeRowsMeta.CheckResult.OneSourceStepMissing"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MergeRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MergeRowsData();
    }
}

