/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class SpeedSearchPopup
extends JPanel {
    private static final int INIT_WIDHT = 120;
    private static final int INIT_HEIHT = 20;
    private int hintWidth = 120;
    private final JLabel myLabel;
    private Component myOwner;
    private Component myFocusCheck;
    private Popup myPopup;

    public SpeedSearchPopup(Component owner, Component focusCheck) {
        this.myOwner = owner;
        this.myFocusCheck = focusCheck;
        this.myLabel = new JLabel();
        this.myLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.myPopup = null;
    }

    public void updatePopupLocation() {
        if (this.myPopup != null) {
            this.createPopup();
        }
    }

    public void createPopup() {
        if (this.myPopup != null) {
            this.myPopup.hide();
        }
        if (this.myFocusCheck.hasFocus()) {
            this.myLabel.setPreferredSize(new Dimension(this.hintWidth, 20));
            Point location = this.myOwner.getLocationOnScreen();
            this.myPopup = PopupFactory.getSharedInstance().getPopup(this.myOwner, this.myLabel, (int)location.getX(), (int)location.getY() - 20);
            this.myPopup.show();
        }
    }

    public void updatePopupText(String text) {
        FontMetrics fm = this.myLabel.getFontMetrics(this.myLabel.getFont());
        if (fm.stringWidth("Search: " + text) > this.hintWidth - fm.getHeight()) {
            this.hintWidth += fm.getHeight() * 3;
            this.createPopup();
        } else if (this.myPopup == null) {
            this.createPopup();
        }
        this.myLabel.setText("<html>Search: <font color=\"FF0000\">" + text + "</font></html>");
    }

    public void destroyPopup() {
        this.hintWidth = 120;
        if (this.myPopup != null) {
            this.myPopup.hide();
        }
        this.myPopup = null;
    }
}

