/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.logging.text.TreeFormatter;

public class AmbiguousTransformException
extends VariantSelectionException {
    public AmbiguousTransformException(String producerDisplayName, AttributeContainerInternal requested, List<TransformedVariant> candidates) {
        super(AmbiguousTransformException.format(producerDisplayName, requested, candidates));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal requested, List<TransformedVariant> candidates) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + producerDisplayName + " with requested attributes");
        AmbiguousTransformException.formatAttributes(formatter, (AttributeContainer)requested);
        formatter.node("Found the following transforms");
        Comparator<TransformedVariant> variantComparator = Comparator.comparing(x -> x.getTransformChain().getDisplayName()).thenComparing(x -> x.getAttributes().toString());
        Map variantToTransforms = candidates.stream().collect(Collectors.groupingBy(TransformedVariant::getRoot, () -> new TreeMap(Comparator.comparing(variant -> variant.asDescribable().getDisplayName())), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(variantComparator).collect(Collectors.toList()))));
        formatter.startChildren();
        for (Map.Entry entry : variantToTransforms.entrySet()) {
            formatter.node("From '" + ((ResolvedVariant)entry.getKey()).asDescribable().getDisplayName() + "'");
            formatter.startChildren();
            formatter.node("With source attributes");
            AmbiguousTransformException.formatAttributes(formatter, (AttributeContainer)((ResolvedVariant)entry.getKey()).getAttributes());
            formatter.node("Candidate transform(s)");
            formatter.startChildren();
            for (TransformedVariant variant : (List)entry.getValue()) {
                formatter.node("Transform '" + variant.getTransformChain().getDisplayName() + "' producing attributes:");
                AmbiguousTransformException.formatAttributes(formatter, (AttributeContainer)variant.getAttributes());
            }
            formatter.endChildren();
            formatter.endChildren();
        }
        formatter.endChildren();
        return formatter.toString();
    }

    public static void formatAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }
}

