/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.ModuleDescriptorMemoryCache;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.NoMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.ResourceHelper;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.PropertiesFile;

public class DefaultRepositoryCacheManager
implements RepositoryCacheManager,
IvySettingsAware {
    private static MessageDigest SHA_DIGEST;
    private IvySettings settings;
    private File basedir;
    private LockStrategy lockStrategy;
    private String name;
    private String ivyPattern;
    private String dataFilePattern = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private String artifactPattern;
    private String lockStrategyName;
    private String changingPattern;
    private String changingMatcherName = "exactOrRegexp";
    private Boolean checkmodified;
    private Boolean useOrigin;
    private ModuleRules ttlRules = new ModuleRules();
    private Long defaultTTL = null;
    private ModuleDescriptorMemoryCache memoryModuleDescrCache;
    private static final Pattern DURATION_PATTERN;

    public DefaultRepositoryCacheManager() {
    }

    public DefaultRepositoryCacheManager(String string, IvySettings ivySettings, File file) {
        this.setName(string);
        this.setSettings(ivySettings);
        this.setBasedir(file);
    }

    public IvySettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public File getIvyFileInCache(ModuleRevisionId object) {
        object = IvyPatternHelper.substitute(this.getIvyPattern(), DefaultArtifact.newIvyArtifact((ModuleRevisionId)object, null));
        return new File(this.getRepositoryCacheRoot(), (String)object);
    }

    public String getIvyPattern() {
        if (this.ivyPattern == null) {
            if (this.settings != null) {
                this.ivyPattern = this.settings.getDefaultCacheIvyPattern();
            }
            if (this.ivyPattern == null) {
                this.ivyPattern = "[organisation]/[module](/[branch])/ivy-[revision].xml";
            }
        }
        return this.ivyPattern;
    }

    public String getArtifactPattern() {
        if (this.artifactPattern == null) {
            if (this.settings != null) {
                this.artifactPattern = this.settings.getDefaultCacheArtifactPattern();
            }
            if (this.artifactPattern == null) {
                this.artifactPattern = "[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])";
            }
        }
        return this.artifactPattern;
    }

    public File getBasedir() {
        if (this.basedir == null) {
            this.basedir = this.settings.getDefaultRepositoryCacheBasedir();
        }
        return this.basedir;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public long getDefaultTTL() {
        if (this.defaultTTL == null) {
            DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
            this.defaultTTL = new Long(defaultRepositoryCacheManager.parseDuration(defaultRepositoryCacheManager.settings.getVariable("ivy.cache.ttl.default")));
        }
        return this.defaultTTL;
    }

    public String getDataFilePattern() {
        return this.dataFilePattern;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setChangingMatcher(String string) {
        this.changingMatcherName = string;
    }

    public void setChangingPattern(String string) {
        this.changingPattern = string;
    }

    public ModuleDescriptorMemoryCache getMemoryCache() {
        if (this.memoryModuleDescrCache == null) {
            this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache(150);
        }
        return this.memoryModuleDescrCache;
    }

    private long parseDuration(String string) {
        if (string == null) {
            return 0L;
        }
        if ("eternal".equals(string)) {
            return Long.MAX_VALUE;
        }
        java.util.regex.Matcher matcher = DURATION_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = this.getGroupIntValue(matcher, 1);
            int n2 = this.getGroupIntValue(matcher, 2);
            int n3 = this.getGroupIntValue(matcher, 3);
            int n4 = this.getGroupIntValue(matcher, 4);
            int n5 = this.getGroupIntValue(matcher, 5);
            return n * 86400000 + n2 * 3600000 + n3 * 60000 + n4 * 1000 + n5;
        }
        throw new IllegalArgumentException("invalid duration '" + string + "': it must match " + DURATION_PATTERN.pattern() + " or 'eternal'");
    }

    private int getGroupIntValue(java.util.regex.Matcher object, int n) {
        if ((object = ((java.util.regex.Matcher)object).group(n)) == null || ((String)object).length() == 0) {
            return 0;
        }
        return Integer.parseInt((String)object);
    }

    public boolean isCheckmodified() {
        if (this.checkmodified == null) {
            if (this.getSettings() != null) {
                String string = this.getSettings().getVariable("ivy.resolver.default.check.modified");
                if (string != null) {
                    return Boolean.valueOf(string);
                }
                return false;
            }
            return false;
        }
        return this.checkmodified;
    }

    public boolean isUseOrigin() {
        if (this.useOrigin == null) {
            if (this.getSettings() != null) {
                return this.getSettings().isDefaultUseOrigin();
            }
            return false;
        }
        return this.useOrigin;
    }

    public void setUseOrigin(boolean bl) {
        this.useOrigin = bl;
    }

    public File getArchiveFileInCache(Artifact artifact) {
        ArtifactOrigin artifactOrigin = this.getSavedArtifactOrigin(artifact);
        return this.getArchiveFileInCache(artifact, artifactOrigin);
    }

    public File getArchiveFileInCache(Artifact object, ArtifactOrigin artifactOrigin) {
        File file = new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache((Artifact)object, artifactOrigin));
        if (!file.exists() && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal() && ((File)(object = Checks.checkAbsolute(artifactOrigin.getLocation(), object + " origin location"))).exists()) {
            return object;
        }
        return file;
    }

    private File getArchiveFileInCache(Artifact artifact, ArtifactOrigin artifactOrigin, boolean bl) {
        if (bl && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal()) {
            return Checks.checkAbsolute(artifactOrigin.getLocation(), artifact + " origin location");
        }
        return new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, artifactOrigin));
    }

    public String getArchivePathInCache(Artifact artifact, ArtifactOrigin artifactOrigin) {
        if (this.isOriginalMetadataArtifact(artifact)) {
            return IvyPatternHelper.substitute(this.getIvyPattern() + ".original", artifact, artifactOrigin);
        }
        return IvyPatternHelper.substitute(this.getArtifactPattern(), artifact, artifactOrigin);
    }

    private void saveResolver(ModuleDescriptor object, String string) {
        object = this.getCachedDataFile((ModuleDescriptor)object);
        ((Properties)object).setProperty("resolver", string);
        ((PropertiesFile)object).save();
    }

    @Override
    public void saveResolvers(ModuleDescriptor object, String string, String string2) {
        ModuleRevisionId moduleRevisionId = object.getResolvedModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            object = this.getCachedDataFile((ModuleDescriptor)object);
            ((Properties)object).setProperty("resolver", string);
            ((Properties)object).setProperty("artifact.resolver", string2);
            ((PropertiesFile)object).save();
            return;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String getSavedResolverName(ModuleDescriptor object) {
        object = this.getCachedDataFile((ModuleDescriptor)object);
        return ((Properties)object).getProperty("resolver");
    }

    private String getSavedArtResolverName(ModuleDescriptor object) {
        object = this.getCachedDataFile((ModuleDescriptor)object);
        return ((Properties)object).getProperty("artifact.resolver");
    }

    void saveArtifactOrigin(Artifact artifact, ArtifactOrigin artifactOrigin) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.setProperty(this.getIsLocalKey(artifact), String.valueOf(artifactOrigin.isLocal()));
        propertiesFile.setProperty(this.getLocationKey(artifact), artifactOrigin.getLocation());
        if (artifactOrigin.getLastChecked() != null) {
            propertiesFile.setProperty(this.getLastCheckedKey(artifact), artifactOrigin.getLastChecked().toString());
        }
        propertiesFile.setProperty(this.getExistsKey(artifact), Boolean.toString(artifactOrigin.isExists()));
        propertiesFile.save();
    }

    private void removeSavedArtifactOrigin(Artifact artifact) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.remove(this.getLocationKey(artifact));
        propertiesFile.remove(this.getIsLocalKey(artifact));
        propertiesFile.remove(this.getLastCheckedKey(artifact));
        propertiesFile.save();
    }

    @Override
    public ArtifactOrigin getSavedArtifactOrigin(Artifact object) {
        ModuleRevisionId moduleRevisionId = object.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return ArtifactOrigin.unkwnown((Artifact)object);
        }
        try {
            Object object2 = this.getCachedDataFile(object.getModuleRevisionId());
            String string = ((Properties)object2).getProperty(this.getLocationKey((Artifact)object));
            String string2 = ((Properties)object2).getProperty(this.getIsLocalKey((Artifact)object));
            String string3 = ((Properties)object2).getProperty(this.getLastCheckedKey((Artifact)object));
            object2 = ((Properties)object2).getProperty(this.getExistsKey((Artifact)object));
            boolean bl = Boolean.valueOf(string2);
            if (string == null) {
                object = ArtifactOrigin.unkwnown((Artifact)object);
                return object;
            }
            object = new ArtifactOrigin((Artifact)object, bl, string);
            if (string3 != null) {
                ((ArtifactOrigin)object).setLastChecked(Long.valueOf(string3));
            }
            if (object2 != null) {
                ((ArtifactOrigin)object).setExist(Boolean.valueOf((String)object2));
            }
            return object;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String getPrefixKey(Artifact artifact) {
        int n = artifact.getId().hashCode();
        return "artifact:" + artifact.getName() + "#" + artifact.getType() + "#" + artifact.getExt() + "#" + n;
    }

    private String getLocationKey(Artifact object) {
        object = this.getPrefixKey((Artifact)object);
        return (String)object + ".location";
    }

    private String getIsLocalKey(Artifact object) {
        object = this.getPrefixKey((Artifact)object);
        return (String)object + ".is-local";
    }

    private String getLastCheckedKey(Artifact object) {
        object = this.getPrefixKey((Artifact)object);
        return (String)object + ".lastchecked";
    }

    private String getExistsKey(Artifact object) {
        object = this.getPrefixKey((Artifact)object);
        return (String)object + ".exists";
    }

    private PropertiesFile getCachedDataFile(ModuleDescriptor moduleDescriptor) {
        return this.getCachedDataFile(moduleDescriptor.getResolvedModuleRevisionId());
    }

    private PropertiesFile getCachedDataFile(ModuleRevisionId moduleRevisionId) {
        return new PropertiesFile(new File(this.getRepositoryCacheRoot(), IvyPatternHelper.substitute(this.getDataFilePattern(), moduleRevisionId)), "ivy cached data file for " + moduleRevisionId);
    }

    @Override
    public ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions, String string) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.isCheckmodified(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": checkModified=true");
            return null;
        }
        if (!cacheMetadataOptions.isUseCacheOnly() && this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": changing=true");
            return null;
        }
        return this.doFindModuleInCache(moduleRevisionId2, cacheMetadataOptions, string);
    }

    /*
     * Unable to fully structure code
     */
    private ResolvedModuleRevision doFindModuleInCache(ModuleRevisionId var1_1, CacheMetadataOptions var2_2, String var3_4) {
        block16: {
            block15: {
                block14: {
                    if (!this.lockMetadataArtifact(var1_1)) {
                        Message.error("impossible to acquire lock for " + var1_1);
                        return null;
                    }
                    var4_5 = true;
                    try {
                        if (!this.settings.getVersionMatcher().isDynamic(var1_1)) break block14;
                        var5_6 = this.getResolvedRevision(var1_1, (CacheMetadataOptions)var2_2);
                        if (var5_6 != null) {
                            Message.verbose("found resolved revision in cache: " + var1_1 + " => " + (String)var5_6);
                            this.unlockMetadataArtifact(var1_1);
                            var1_1 = ModuleRevisionId.newInstance(var1_1, (String)var5_6);
                            if (!this.lockMetadataArtifact(var1_1)) {
                                Message.error("impossible to acquire lock for " + var1_1);
                                var4_5 = false;
                                return null;
                            }
                            break block14;
                        }
                        this.unlockMetadataArtifact(var1_1);
                        return null;
                    }
                    catch (Throwable var2_3) {
                        if (var4_5) {
                            this.unlockMetadataArtifact(var1_1);
                        }
                        throw var2_3;
                    }
                }
                var5_6 = this.getIvyFileInCache(var1_1);
                if (!var5_6.exists()) ** GOTO lbl63
                var6_7 = XmlModuleDescriptorParser.getInstance();
                var2_2 = this.getMdFromCache((XmlModuleDescriptorParser)var6_7, (CacheMetadataOptions)var2_2, (File)var5_6);
                var6_7 = this.getSavedResolverName((ModuleDescriptor)var2_2);
                var7_9 = this.getSavedArtResolverName((ModuleDescriptor)var2_2);
                var8_10 = this.settings.getResolver((String)var6_7);
                if (var8_10 == null) {
                    Message.debug("\tresolver not found: " + (String)var6_7 + " => trying to use the one configured for " + var1_1);
                    var8_10 = this.settings.getResolver(var2_2.getResolvedModuleRevisionId());
                    if (var8_10 != null) {
                        Message.debug("\tconfigured resolver found for " + var2_2.getResolvedModuleRevisionId() + ": " + var8_10.getName() + ": saving this data");
                        this.saveResolver((ModuleDescriptor)var2_2, var8_10.getName());
                    }
                }
                if ((var7_9 = this.settings.getResolver((String)var7_9)) == null) {
                    var7_9 = var8_10;
                }
                if (var8_10 == null) ** GOTO lbl58
                Message.debug("\tfound ivy file in cache for " + var1_1 + " (resolved by " + var8_10.getName() + "): " + var5_6);
                if (var3_4 != null && !var3_4.equals(var8_10.getName())) break block15;
                var3_4 = new MetadataArtifactDownloadReport(var2_2.getMetadataArtifact());
                var3_4.setDownloadStatus(DownloadStatus.NO);
                var3_4.setSearched(false);
                var3_4.setLocalFile((File)var5_6);
                var3_4.setSize(var5_6.length());
                var3_4.setArtifactOrigin(this.getSavedArtifactOrigin(var2_2.getMetadataArtifact()));
                var2_2 = new ResolvedModuleRevision(var8_10, (DependencyResolver)var7_9, (ModuleDescriptor)var2_2, (MetadataArtifactDownloadReport)var3_4);
                this.unlockMetadataArtifact(var1_1);
                return var2_2;
            }
            Message.debug("found module in cache but with a different resolver: discarding: " + var1_1 + "; expected resolver=" + (String)var3_4 + "; resolver=" + var8_10.getName());
            break block16;
lbl58:
            // 1 sources

            Message.debug("\tresolver not found: " + (String)var6_7 + " => cannot use cached ivy file for " + var1_1);
            {
                catch (Exception var6_8) {
                    Message.debug("\tproblem while parsing cached ivy file for: " + var1_1 + ": " + var6_8.getMessage());
                }
            }
            break block16;
lbl63:
            // 1 sources

            Message.debug("\tno ivy file in cache for " + var1_1 + ": tried " + var5_6);
        }
        this.unlockMetadataArtifact(var1_1);
        return null;
    }

    private ModuleDescriptor getMdFromCache(XmlModuleDescriptorParser object, CacheMetadataOptions cacheMetadataOptions, File file) throws ParseException, IOException {
        ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = this.getMemoryCache();
        object = new MyModuleDescriptorProvider((ModuleDescriptorParser)object, this.settings);
        return moduleDescriptorMemoryCache.get(file, this.settings, cacheMetadataOptions.isValidate(), (ModuleDescriptorProvider)object);
    }

    private ModuleDescriptor getStaledMd(ModuleDescriptorParser object, CacheMetadataOptions cacheMetadataOptions, File file, ParserSettings parserSettings) throws ParseException, IOException {
        ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = this.getMemoryCache();
        object = new MyModuleDescriptorProvider((ModuleDescriptorParser)object, parserSettings);
        return moduleDescriptorMemoryCache.getStale(file, this.settings, cacheMetadataOptions.isValidate(), (ModuleDescriptorProvider)object);
    }

    private String getResolvedRevision(ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        long l;
        String string;
        Object object;
        block9: {
            block8: {
                block7: {
                    if (!this.lockMetadataArtifact(moduleRevisionId)) {
                        Message.error("impossible to acquire lock for " + moduleRevisionId);
                        return null;
                    }
                    try {
                        if (!cacheMetadataOptions.isForce()) break block7;
                        Message.verbose("refresh mode: no check for cached resolved revision for " + moduleRevisionId);
                        this.unlockMetadataArtifact(moduleRevisionId);
                        return null;
                    }
                    catch (Throwable throwable) {
                        this.unlockMetadataArtifact(moduleRevisionId);
                        throw throwable;
                    }
                }
                object = this.getCachedDataFile(moduleRevisionId);
                string = ((Properties)object).getProperty("resolved.revision");
                if (string != null) break block8;
                Message.verbose(this.getName() + ": no cached resolved revision for " + moduleRevisionId);
                this.unlockMetadataArtifact(moduleRevisionId);
                return null;
            }
            object = ((Properties)object).getProperty("resolved.time");
            if (object != null) break block9;
            Message.verbose(this.getName() + ": inconsistent or old cache: no cached resolved time for " + moduleRevisionId);
            this.saveResolvedRevision(moduleRevisionId, string);
            String string2 = string;
            this.unlockMetadataArtifact(moduleRevisionId);
            return string2;
        }
        if (cacheMetadataOptions.isCheckTTL() && (l = Long.parseLong((String)object) + this.getTTL(moduleRevisionId)) > 0L && System.currentTimeMillis() > l) {
            Message.verbose(this.getName() + ": cached resolved revision expired for " + moduleRevisionId);
            this.unlockMetadataArtifact(moduleRevisionId);
            return null;
        }
        String string3 = string;
        this.unlockMetadataArtifact(moduleRevisionId);
        return string3;
    }

    @Override
    public void saveResolvedRevision(ModuleRevisionId moduleRevisionId, String string) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleRevisionId);
            propertiesFile.setProperty("resolved.time", String.valueOf(System.currentTimeMillis()));
            propertiesFile.setProperty("resolved.revision", string);
            propertiesFile.save();
            return;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    public long getTTL(ModuleRevisionId object) {
        if ((object = (Long)this.ttlRules.getRule((ModuleRevisionId)object)) == null) {
            return this.getDefaultTTL();
        }
        return (Long)object;
    }

    public String toString() {
        return this.name;
    }

    public File getRepositoryCacheRoot() {
        return this.getBasedir();
    }

    public LockStrategy getLockStrategy() {
        if (this.lockStrategy == null) {
            this.lockStrategy = this.lockStrategyName != null ? this.settings.getLockStrategy(this.lockStrategyName) : this.settings.getDefaultLockStrategy();
        }
        return this.lockStrategy;
    }

    @Override
    public ArtifactDownloadReport download(Artifact artifact, ArtifactResourceResolver artifactResourceResolver, ResourceDownloader resourceDownloader, CacheDownloadOptions object) {
        ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifact);
        boolean bl = this.isUseOrigin();
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
            artifactDownloadReport.setDownloadDetails("impossible to get lock for " + moduleRevisionId);
            return artifactDownloadReport;
        }
        try {
            ArtifactOrigin artifactOrigin;
            File file;
            DownloadListener downloadListener = ((CacheDownloadOptions)object).getListener();
            if (downloadListener != null) {
                downloadListener.needArtifact(this, artifact);
            }
            if ((file = this.getArchiveFileInCache(artifact, artifactOrigin = this.getSavedArtifactOrigin(artifact), bl)).exists() && !((CacheDownloadOptions)object).isForce()) {
                artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                artifactDownloadReport.setSize(file.length());
                artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                artifactDownloadReport.setLocalFile(file);
            } else {
                long l = System.currentTimeMillis();
                try {
                    object = artifactResourceResolver.resolve(artifact);
                    if (object != null) {
                        artifactOrigin = new ArtifactOrigin(artifact, ((ResolvedResource)object).getResource().isLocal(), ((ResolvedResource)object).getResource().getName());
                        if (bl && ((ResolvedResource)object).getResource().isLocal()) {
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            file = this.getArchiveFileInCache(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                            artifactDownloadReport.setSize(file.length());
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file);
                        } else {
                            file = this.getArchiveFileInCache(artifact, artifactOrigin, bl);
                            if (ResourceHelper.equals(((ResolvedResource)object).getResource(), file)) {
                                throw new IllegalStateException("invalid settings for '" + artifactResourceResolver + "': pointing repository to ivy cache is forbidden !");
                            }
                            if (downloadListener != null) {
                                downloadListener.startArtifactDownload(this, (ResolvedResource)object, artifact, artifactOrigin);
                            }
                            resourceDownloader.download(artifact, ((ResolvedResource)object).getResource(), file);
                            artifactDownloadReport.setSize(file.length());
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file);
                        }
                    } else {
                        artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                        artifactDownloadReport.setDownloadDetails("missing artifact");
                        artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                    }
                }
                catch (Exception exception) {
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                    artifactDownloadReport.setDownloadDetails(exception.getMessage());
                    artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                }
            }
            if (downloadListener != null) {
                downloadListener.endArtifactDownload(this, artifact, artifactDownloadReport, file);
            }
            ArtifactDownloadReport artifactDownloadReport2 = artifactDownloadReport;
            return artifactDownloadReport2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    @Override
    public void originalToCachedModuleDescriptor(DependencyResolver dependencyResolver, ResolvedResource resolvedResource, Artifact extendableItem, ResolvedModuleRevision resolvedModuleRevision, ModuleDescriptorWriter moduleDescriptorWriter) {
        ModuleDescriptor moduleDescriptor = resolvedModuleRevision.getDescriptor();
        Object object = this.getOriginalMetadataArtifact((Artifact)extendableItem);
        File file = this.getIvyFileInCache(moduleDescriptor.getResolvedModuleRevisionId());
        if (!this.lockMetadataArtifact((ModuleRevisionId)(extendableItem = extendableItem.getModuleRevisionId()))) {
            Message.warn("impossible to acquire lock for: " + extendableItem);
            return;
        }
        try {
            object = this.getArchiveFileInCache((Artifact)object);
            moduleDescriptorWriter.write(resolvedResource, moduleDescriptor, (File)object, file);
            this.getMemoryCache().putInCache(file, new ParserSettingsMonitor(this.settings), true, moduleDescriptor);
            this.saveResolvers(moduleDescriptor, dependencyResolver.getName(), dependencyResolver.getName());
            if (!moduleDescriptor.isDefault()) {
                resolvedModuleRevision.getReport().setOriginalLocalFile((File)object);
            }
            resolvedModuleRevision.getReport().setLocalFile(file);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            Message.warn("impossible to put metadata file in cache: " + (resolvedResource == null ? String.valueOf(moduleDescriptor.getResolvedModuleRevisionId()) : String.valueOf(resolvedResource)) + ". " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        finally {
            this.unlockMetadataArtifact((ModuleRevisionId)extendableItem);
        }
    }

    @Override
    public ResolvedModuleRevision cacheModuleDescriptor(DependencyResolver dependencyResolver, final ResolvedResource resolvedResource, DependencyDescriptor object, Artifact object2, ResourceDownloader resourceDownloader, CacheMetadataOptions cacheMetadataOptions) throws ParseException {
        Date date = null;
        ModuleRevisionId moduleRevisionId = object2.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        resourceDownloader = new BackupResourceDownloader(resourceDownloader);
        try {
            ModuleDescriptor moduleDescriptor;
            if (!object2.isMetadata()) {
                if (this.isChanging((DependencyDescriptor)object, moduleRevisionId, cacheMetadataOptions)) {
                    ArtifactOrigin artifactOrigin;
                    long l = resolvedResource.getLastModified();
                    Artifact artifact = NameSpaceHelper.transform((Artifact)object2, cacheMetadataOptions.getNamespace().getToSystemTransformer());
                    File file = this.getArchiveFileInCache(artifact, artifactOrigin = this.getSavedArtifactOrigin(artifact), false);
                    if (file.exists() && l > file.lastModified()) {
                        Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                        Message.debug("deleting " + file);
                        if (!file.delete()) {
                            Message.error("Couldn't delete outdated artifact from cache: " + file);
                            return null;
                        }
                        this.removeSavedArtifactOrigin(artifact);
                    }
                }
                return null;
            }
            ResolvedModuleRevision resolvedModuleRevision = this.doFindModuleInCache(moduleRevisionId, cacheMetadataOptions, null);
            if (resolvedModuleRevision != null) {
                if (resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision.getResolver() != dependencyResolver) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    if (!this.isCheckmodified((DependencyDescriptor)object, moduleRevisionId, cacheMetadataOptions) && !this.isChanging((DependencyDescriptor)object, moduleRevisionId, cacheMetadataOptions)) {
                        Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
                        return resolvedModuleRevision2;
                    }
                    long l = resolvedResource.getLastModified();
                    long l2 = resolvedModuleRevision.getDescriptor().getLastModified();
                    if (!resolvedModuleRevision.getDescriptor().isDefault() && l <= l2) {
                        Message.verbose("\t" + this.getName() + ": revision in cache (not updated): " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision;
                        return resolvedModuleRevision3;
                    }
                    Message.verbose("\t" + this.getName() + ": revision in cache is not up to date: " + moduleRevisionId);
                    if (this.isChanging((DependencyDescriptor)object, moduleRevisionId, cacheMetadataOptions)) {
                        date = resolvedModuleRevision.getDescriptor().getResolvedPublicationDate();
                    }
                }
            }
            Artifact artifact = this.getOriginalMetadataArtifact((Artifact)object2);
            object2 = this.download(artifact, new ArtifactResourceResolver(){

                @Override
                public ResolvedResource resolve(Artifact artifact) {
                    return resolvedResource;
                }
            }, resourceDownloader, new CacheDownloadOptions().setListener(cacheMetadataOptions.getListener()).setForce(true));
            Message.verbose("\t" + object2);
            if (((ArtifactDownloadReport)object2).getDownloadStatus() == DownloadStatus.FAILED) {
                Message.warn("problem while downloading module descriptor: " + resolvedResource.getResource() + ": " + ((ArtifactDownloadReport)object2).getDownloadDetails() + " (" + ((ArtifactDownloadReport)object2).getDownloadTimeMillis() + "ms)");
                return null;
            }
            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
            ParserSettings parserSettings = this.settings;
            if (dependencyResolver instanceof AbstractResolver) {
                parserSettings = ((AbstractResolver)dependencyResolver).getParserSettings();
            }
            if ((moduleDescriptor = this.getStaledMd(moduleDescriptorParser, cacheMetadataOptions, ((ArtifactDownloadReport)object2).getLocalFile(), parserSettings)) == null) {
                throw new IllegalStateException("module descriptor parser returned a null module descriptor, which is not allowed. parser=" + moduleDescriptorParser + "; parser class=" + moduleDescriptorParser.getClass().getName() + "; module descriptor resource=" + resolvedResource.getResource());
            }
            Message.debug("\t" + this.getName() + ": parsed downloaded md file for " + moduleRevisionId + "; parsed=" + moduleDescriptor.getModuleRevisionId());
            boolean bl = false;
            if (date != null && !date.equals(moduleDescriptor.getResolvedPublicationDate())) {
                Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                bl = true;
            }
            if (bl) {
                object = moduleDescriptor.getConfigurationsNames();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    Artifact[] artifactArray = moduleDescriptor.getArtifacts(object[i]);
                    for (int j = 0; j < artifactArray.length; ++j) {
                        if (this.prepAndDeleteArtifact(artifactArray[j], cacheMetadataOptions, (BackupResourceDownloader)resourceDownloader)) continue;
                        return null;
                    }
                }
                if ("true".equals(this.settings.substitute("${alwaysDeleteSourcesAndJavadocJarsOnChangedModuleDescriptor}"))) {
                    MDArtifact mDArtifact = new MDArtifact(moduleDescriptor, moduleRevisionId.getName(), "src", "jar", null, Collections.singletonMap("m:classifier", "sources"));
                    MDArtifact mDArtifact2 = new MDArtifact(moduleDescriptor, moduleRevisionId.getName(), "src", "jar", null, Collections.singletonMap("m:classifier", "src"));
                    MDArtifact mDArtifact3 = new MDArtifact(moduleDescriptor, moduleRevisionId.getName(), "doc", "jar", null, Collections.singletonMap("m:classifier", "javadoc"));
                    if (!this.prepAndDeleteArtifact(mDArtifact, cacheMetadataOptions, (BackupResourceDownloader)resourceDownloader)) {
                        return null;
                    }
                    if (!this.prepAndDeleteArtifact(mDArtifact2, cacheMetadataOptions, (BackupResourceDownloader)resourceDownloader)) {
                        return null;
                    }
                    if (!this.prepAndDeleteArtifact(mDArtifact3, cacheMetadataOptions, (BackupResourceDownloader)resourceDownloader)) {
                        return null;
                    }
                }
            } else if (this.isChanging((DependencyDescriptor)object, moduleRevisionId, cacheMetadataOptions)) {
                Message.verbose(moduleRevisionId + " is changing, but has not changed: will trust cached artifacts if any");
            }
            object = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
            ((MetadataArtifactDownloadReport)object).setSearched(true);
            ((ArtifactDownloadReport)object).setDownloadStatus(((ArtifactDownloadReport)object2).getDownloadStatus());
            ((ArtifactDownloadReport)object).setDownloadDetails(((ArtifactDownloadReport)object2).getDownloadDetails());
            ((ArtifactDownloadReport)object).setArtifactOrigin(((ArtifactDownloadReport)object2).getArtifactOrigin());
            ((ArtifactDownloadReport)object).setDownloadTimeMillis(((ArtifactDownloadReport)object2).getDownloadTimeMillis());
            ((MetadataArtifactDownloadReport)object).setOriginalLocalFile(((ArtifactDownloadReport)object2).getLocalFile());
            ((ArtifactDownloadReport)object).setSize(((ArtifactDownloadReport)object2).getSize());
            Artifact artifact2 = NameSpaceHelper.transform(moduleDescriptor.getMetadataArtifact(), cacheMetadataOptions.getNamespace().getToSystemTransformer());
            this.saveArtifactOrigin(artifact2, ((ArtifactDownloadReport)object2).getArtifactOrigin());
            DependencyResolver dependencyResolver2 = dependencyResolver;
            ResolvedModuleRevision resolvedModuleRevision4 = new ResolvedModuleRevision(dependencyResolver2, dependencyResolver2, moduleDescriptor, (MetadataArtifactDownloadReport)object);
            return resolvedModuleRevision4;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
            ((BackupResourceDownloader)resourceDownloader).cleanUp();
        }
    }

    private boolean lockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = this.getDefaultMetadataArtifact(moduleRevisionId);
        try {
            return this.getLockStrategy().lockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("operation interrupted");
        }
    }

    private void unlockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = this.getDefaultMetadataArtifact(moduleRevisionId);
        this.getLockStrategy().unlockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
    }

    private ArtifactOrigin getDefaultMetadataArtifactOrigin(ModuleRevisionId moduleRevisionId) {
        return new ArtifactOrigin(DefaultArtifact.newIvyArtifact(moduleRevisionId, null), false, this.getIvyFileInCache(moduleRevisionId).getPath());
    }

    private Artifact getDefaultMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        return new DefaultArtifact(moduleRevisionId, new Date(), "metadata", "metadata", "ivy", true);
    }

    public Artifact getOriginalMetadataArtifact(Artifact artifact) {
        return DefaultArtifact.cloneWithAnotherType(artifact, artifact.getType() + ".original");
    }

    private boolean isOriginalMetadataArtifact(Artifact artifact) {
        return artifact.isMetadata() && artifact.getType().endsWith(".original");
    }

    private boolean isChanging(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        return dependencyDescriptor.isChanging() || this.getChangingMatcher(cacheMetadataOptions).matches(moduleRevisionId.getRevision());
    }

    private Matcher getChangingMatcher(CacheMetadataOptions object) {
        String string = ((CacheMetadataOptions)object).getChangingPattern() != null ? ((CacheMetadataOptions)object).getChangingPattern() : this.changingPattern;
        if (string == null) {
            return NoMatcher.INSTANCE;
        }
        PatternMatcher patternMatcher = this.settings.getMatcher((String)(object = ((CacheMetadataOptions)object).getChangingMatcherName() != null ? ((CacheMetadataOptions)object).getChangingMatcherName() : this.changingMatcherName));
        if (patternMatcher == null) {
            throw new IllegalStateException("unknown matcher '" + (String)object + "'. It is set as changing matcher in " + this);
        }
        return patternMatcher.getMatcher(string);
    }

    private boolean isCheckmodified(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        if (cacheMetadataOptions.isCheckmodified() != null) {
            return cacheMetadataOptions.isCheckmodified();
        }
        return this.isCheckmodified();
    }

    private boolean prepAndDeleteArtifact(Artifact artifact, CacheMetadataOptions object, BackupResourceDownloader backupResourceDownloader) throws IOException {
        artifact = NameSpaceHelper.transform(artifact, ((CacheMetadataOptions)object).getNamespace().getToSystemTransformer());
        object = this.getSavedArtifactOrigin(artifact);
        if (((File)(object = this.getArchiveFileInCache(artifact, (ArtifactOrigin)object, false))).exists()) {
            Message.debug("deleting " + object);
            if (!((File)object).delete()) {
                backupResourceDownloader.restore();
                Message.error("Couldn't delete outdated artifact from cache: " + object);
                return false;
            }
        }
        this.removeSavedArtifactOrigin(artifact);
        return true;
    }

    static {
        try {
            SHA_DIGEST = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA1 algorithm is not available in your classpath", noSuchAlgorithmException);
        }
        DURATION_PATTERN = Pattern.compile("(?:(\\d+)d)? ?(?:(\\d+)h)? ?(?:(\\d+)m)? ?(?:(\\d+)s)? ?(?:(\\d+)ms)?");
    }

    private final class BackupResourceDownloader
    implements ResourceDownloader {
        private ResourceDownloader delegate;
        private File backup;
        private String originalPath;

        private BackupResourceDownloader(ResourceDownloader resourceDownloader) {
            this.delegate = resourceDownloader;
        }

        @Override
        public final void download(Artifact artifact, Resource resource, File file) throws IOException {
            if (file.exists()) {
                this.originalPath = file.getAbsolutePath();
                this.backup = new File(file.getAbsolutePath() + ".backup");
                FileUtil.copy(file, this.backup, null, true);
            }
            this.delegate.download(artifact, resource, file);
        }

        public final void restore() throws IOException {
            if (this.backup != null && this.backup.exists()) {
                File file = new File(this.originalPath);
                FileUtil.copy(this.backup, file, null, true);
                this.backup.delete();
            }
        }

        public final void cleanUp() {
            if (this.backup != null && this.backup.exists()) {
                this.backup.delete();
            }
        }
    }

    private class MyModuleDescriptorProvider
    implements ModuleDescriptorProvider {
        private final ModuleDescriptorParser mdParser;
        private final ParserSettings settings;

        public MyModuleDescriptorProvider(ModuleDescriptorParser moduleDescriptorParser, ParserSettings parserSettings) {
            this.mdParser = moduleDescriptorParser;
            this.settings = parserSettings;
        }

        @Override
        public ModuleDescriptor provideModule(ParserSettings parserSettings, File file, boolean bl) throws ParseException, IOException {
            return this.mdParser.parseDescriptor(this.settings, file.toURI().toURL(), bl);
        }
    }
}

