/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.solr.handler.sql.SolrMethod;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;
import org.apache.solr.handler.sql.SolrTable;

class SolrToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    SolrToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SolrToEnumerableConverter(this.getCluster(), traitSet, (RelNode)SolrToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        SolrRel.Implementor solrImplementor = new SolrRel.Implementor();
        solrImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression table = list.append("table", solrImplementor.table.getExpression(SolrTable.SolrQueryable.class));
        Expression fields = list.append("fields", (Expression)SolrToEnumerableConverter.constantArrayList(Pair.zip(this.generateFields(SolrRules.solrFieldNames(rowType), solrImplementor.fieldMappings), (List)new AbstractList<Class<?>>(){

            @Override
            public Class<?> get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression query = list.append("query", (Expression)Expressions.constant((Object)solrImplementor.query, String.class));
        Expression orders = list.append("orders", (Expression)SolrToEnumerableConverter.constantArrayList(solrImplementor.orders, Pair.class));
        Expression buckets = list.append("buckets", (Expression)SolrToEnumerableConverter.constantArrayList(solrImplementor.buckets, String.class));
        Expression metricPairs = list.append("metricPairs", (Expression)SolrToEnumerableConverter.constantArrayList(solrImplementor.metricPairs, Pair.class));
        Expression limit = list.append("limit", (Expression)Expressions.constant((Object)solrImplementor.limitValue));
        Expression negativeQuery = list.append("negativeQuery", (Expression)Expressions.constant((Object)Boolean.toString(solrImplementor.negativeQuery), String.class));
        Expression havingPredicate = list.append("havingTest", (Expression)Expressions.constant((Object)solrImplementor.havingPredicate, String.class));
        Expression offset = list.append("offset", (Expression)Expressions.constant((Object)solrImplementor.offsetValue));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)SolrMethod.SOLR_QUERYABLE_QUERY.method, (Expression[])new Expression[]{fields, query, orders, buckets, metricPairs, limit, negativeQuery, havingPredicate, offset}));
        Hook.QUERY_PLAN.run((Object)query);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private List<String> generateFields(List<String> queryFields, Map<String, String> fieldMappings) {
        if (fieldMappings.isEmpty()) {
            return queryFields;
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : queryFields) {
            fields.add(this.getField(fieldMappings, field));
        }
        return fields;
    }

    private String getField(Map<String, String> fieldMappings, String field) {
        String retField = field;
        while (fieldMappings.containsKey(field) && !retField.equals(field = fieldMappings.getOrDefault(field, retField))) {
            retField = field;
        }
        return retField;
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class<?> clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit(clazz, SolrToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return values.stream().map(Expressions::constant).collect(Collectors.toUnmodifiableList());
    }
}

