/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.assignor.AbstractUniformAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GeneralUniformAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.OptimizedUniformAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformAssignor
implements PartitionAssignor {
    private static final Logger LOG = LoggerFactory.getLogger(UniformAssignor.class);
    public static final String UNIFORM_ASSIGNOR_NAME = "uniform";

    @Override
    public String name() {
        return UNIFORM_ASSIGNOR_NAME;
    }

    @Override
    public GroupAssignment assign(AssignmentSpec assignmentSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        AbstractUniformAssignmentBuilder assignmentBuilder;
        if (assignmentSpec.members().isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        if (this.allSubscriptionsEqual(assignmentSpec.members())) {
            LOG.debug("Detected that all members are subscribed to the same set of topics, invoking the optimized assignment algorithm");
            assignmentBuilder = new OptimizedUniformAssignmentBuilder(assignmentSpec, subscribedTopicDescriber);
        } else {
            LOG.debug("Detected that the members are subscribed to different sets of topics, invoking the general assignment algorithm");
            assignmentBuilder = new GeneralUniformAssignmentBuilder(assignmentSpec, subscribedTopicDescriber);
        }
        return assignmentBuilder.buildAssignment();
    }

    private boolean allSubscriptionsEqual(Map<String, AssignmentMemberSpec> members) {
        HashSet<Uuid> firstSubscriptionSet = new HashSet<Uuid>(members.values().iterator().next().subscribedTopicIds());
        for (AssignmentMemberSpec memberSpec : members.values()) {
            if (firstSubscriptionSet.size() == memberSpec.subscribedTopicIds().size() && firstSubscriptionSet.containsAll(memberSpec.subscribedTopicIds())) continue;
            return false;
        }
        return true;
    }
}

