/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.util.DateMathParser;

public class ValueAugmenterFactory
extends TransformerFactory {
    protected Object value = null;
    protected Object defaultValue = null;

    @Override
    public void init(NamedList<?> args) {
        this.value = args.get("value");
        if (this.value == null) {
            this.defaultValue = args.get("defaultValue");
        }
    }

    public static Object getObjectFrom(String val, String type) {
        if (type != null) {
            try {
                if ("int".equals(type)) {
                    return Integer.valueOf(val);
                }
                if ("double".equals(type)) {
                    return Double.valueOf(val);
                }
                if ("float".equals(type)) {
                    return Float.valueOf(val);
                }
                if ("date".equals(type)) {
                    return DateMathParser.parseMath(null, val);
                }
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse " + type + "=" + val, (Throwable)ex);
            }
        }
        return val;
    }

    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        String v;
        Object val = this.value;
        if (val == null && (val = (v = params.get("v")) == null ? this.defaultValue : ValueAugmenterFactory.getObjectFrom(v, params.get("t"))) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ValueAugmenter is missing a value -- should be defined in solrconfig or inline");
        }
        return new ValueAugmenter(field, val);
    }

    public static class ValueAugmenter
    extends DocTransformer {
        private final String name;
        protected final Object value;

        public ValueAugmenter(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void transform(SolrDocument doc, int docid) {
            doc.setField(this.name, this.value);
        }
    }
}

